/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public final class UnionFeatureExtractor<S>
implements IFeatureExtractor<S> {
    private static final long serialVersionUID = 4282542059746066268L;
    private final List<? extends IFeatureExtractor<S>> featureExtractors;

    @SafeVarargs
    public UnionFeatureExtractor(IFeatureExtractor<S> ... featureExtractors) {
        this(Arrays.asList(featureExtractors));
    }

    public UnionFeatureExtractor(List<? extends IFeatureExtractor<S>> featureExtractors) {
        Validate.notEmpty(featureExtractors, (String)"At least one feature extractor should be provided.");
        this.featureExtractors = featureExtractors;
    }

    public Map<Feature, IValue> extract(S source) {
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        for (int i = 0; i < this.featureExtractors.size(); ++i) {
            Map instance = this.featureExtractors.get(i).extract(source);
            for (Map.Entry featureAndValue : instance.entrySet()) {
                featuresValues.put(this.getNamespacedFeature(i, (Feature)featureAndValue.getKey()), (IValue)featureAndValue.getValue());
            }
        }
        return featuresValues;
    }

    private Feature getNamespacedFeature(int i, Feature feature) {
        String featureName = i + "\t" + feature.getName();
        return new Feature(featureName, feature.getType());
    }
}

