/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public final class StackFeatureExtractor<S>
implements IFeatureExtractor<List<S>> {
    private static final long serialVersionUID = 7388243925891750225L;
    private final IFeatureExtractor<? super S> wrapped;

    public StackFeatureExtractor(IFeatureExtractor<? super S> wrapped) {
        this.wrapped = wrapped;
    }

    public Map<Feature, IValue> extract(List<S> sources) {
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        for (int i = 0; i < sources.size(); ++i) {
            Map instance = this.wrapped.extract(sources.get(i));
            for (Map.Entry featureAndValue : instance.entrySet()) {
                featuresValues.put(this.getNamespacedFeature(i, (Feature)featureAndValue.getKey()), (IValue)featureAndValue.getValue());
            }
        }
        return featuresValues;
    }

    private Feature getNamespacedFeature(int i, Feature feature) {
        String featureName = i + "\t" + feature.getName();
        return new Feature(featureName, feature.getType());
    }
}

