/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.DoubleValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public final class AveragingFeatureExtractor<S>
implements IFeatureExtractor<List<S>> {
    private static final long serialVersionUID = 6853723672248975536L;
    private final IFeatureExtractor<? super S> wrapped;

    public AveragingFeatureExtractor(IFeatureExtractor<? super S> wrapped) {
        this.wrapped = wrapped;
    }

    public Map<Feature, IValue> extract(List<S> sources) {
        List<Map<Feature, IValue>> instances = this.extractEach(sources);
        Map<Feature, List<IValue>> feature2Values = this.getFeatures2Values(instances);
        Map<Feature, IValue> featuresValues = this.getFeaturesValues(feature2Values, sources.size());
        return featuresValues;
    }

    private List<Map<Feature, IValue>> extractEach(List<S> sources) {
        ArrayList<Map<Feature, IValue>> result = new ArrayList<Map<Feature, IValue>>();
        for (S source : sources) {
            result.add(this.wrapped.extract(source));
        }
        return result;
    }

    private Map<Feature, List<IValue>> getFeatures2Values(List<Map<Feature, IValue>> instances) {
        HashMap<Feature, List<IValue>> result = new HashMap<Feature, List<IValue>>();
        for (Map<Feature, IValue> instance : instances) {
            for (Map.Entry<Feature, IValue> featureAndValue : instance.entrySet()) {
                Feature feature = featureAndValue.getKey();
                ArrayList<IValue> values = (ArrayList<IValue>)result.get(feature);
                if (values == null) {
                    values = new ArrayList<IValue>();
                    result.put(feature, values);
                }
                values.add(featureAndValue.getValue());
            }
        }
        return result;
    }

    private Map<Feature, IValue> getFeaturesValues(Map<Feature, List<IValue>> feature2Values, int size) {
        HashMap<Feature, IValue> result = new HashMap<Feature, IValue>();
        for (Map.Entry<Feature, List<IValue>> featureAndValues : feature2Values.entrySet()) {
            Feature feature = featureAndValues.getKey();
            List<IValue> values = featureAndValues.getValue();
            IValue value = this.getAverageValue(feature, values, size);
            result.put(new Feature(feature.getName(), Type.DOUBLE), value);
        }
        return result;
    }

    private IValue getAverageValue(Feature feature, List<IValue> values, int size) {
        double sum;
        switch (feature.getType()) {
            case BOOLEAN: {
                sum = this.getBooleanSum(values);
                break;
            }
            case INTEGER: {
                sum = this.getIntegerSum(values);
                break;
            }
            case DOUBLE: {
                sum = this.getDoubleSum(values);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s is not numerical.", feature));
            }
        }
        return new DoubleValue(sum / (double)size);
    }

    private double getBooleanSum(List<IValue> values) {
        double sum = 0.0;
        for (IValue value : values) {
            sum += (double)(value.getBoolean() ? 1 : 0);
        }
        return sum;
    }

    private double getIntegerSum(List<IValue> values) {
        double sum = 0.0;
        for (IValue value : values) {
            sum += (double)value.getInt();
        }
        return sum;
    }

    private double getDoubleSum(List<IValue> values) {
        double sum = 0.0;
        for (IValue value : values) {
            sum += value.getDouble();
        }
        return sum;
    }
}

