/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.lemmatizer.wordProcessors;

import java.util.regex.Pattern;
import ru.ispras.texterra.core.nlp.annotators.lemmatizer.wordProcessors.IWordPreProcessor;

public class PunctuationProcessor
implements IWordPreProcessor {
    private static final long serialVersionUID = -4799936373855908214L;
    private static final String punctuationPattern = "[\\p{Punct}$\u00a3\u00a5\u20ac+<>\u25cf\u00a9\u00b0~`=^]";
    private static final Pattern prefixPunctuationPattern = Pattern.compile("^[\\p{Punct}$\u00a3\u00a5\u20ac+<>\u25cf\u00a9\u00b0~`=^]+", 256);
    private static final Pattern suffixPunctuationPattern = Pattern.compile("[\\p{Punct}$\u00a3\u00a5\u20ac+<>\u25cf\u00a9\u00b0~`=^]+$", 256);

    @Override
    public String getLemma(String word) {
        word = prefixPunctuationPattern.matcher(word).replaceFirst("");
        word = suffixPunctuationPattern.matcher(word).replaceFirst("");
        return word;
    }
}

