/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.lemmatizer.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.ispras.texterra.core.nlp.annotators.lemmatizer.model.CharTrieNode;
import ru.ispras.texterra.core.nlp.annotators.lemmatizer.model.RuleNode;

public class ModelTrainer {
    private static final Logger logger = Logger.getLogger(ModelTrainer.class);
    private final char endOfWordChar;

    public ModelTrainer(char endOfWordChar) {
        this.endOfWordChar = endOfWordChar;
    }

    public RuleNode train(List<WordLemma> lemmaList) {
        logger.debug((Object)(lemmaList.size() + " word-lemmas pairs"));
        RuleNode root = new RuleNode("");
        Collections.sort(lemmaList, new LemmaComparator());
        this.trainRecursive(root, lemmaList);
        return root;
    }

    private RuleNode trainRecursive(RuleNode root, List<WordLemma> lemmaList) {
        if (lemmaList.size() == 0) {
            return root;
        }
        if (lemmaList.size() == 1) {
            this.addDictionaryNode(root, lemmaList.get(0).getWord(), lemmaList.get(0).getLemma());
            return root;
        }
        if (lemmaList.get(0).getWord().equals(lemmaList.get(lemmaList.size() - 1).getWord())) {
            String rule = this.mostFrequentRule(lemmaList.get(0).getWord(), lemmaList);
            this.addDictionaryNode(root, lemmaList.get(0).getWord(), rule);
            return root;
        }
        String commonSuffix = this.getCommonSuffix(lemmaList);
        String rule = this.mostFrequentRule(commonSuffix, lemmaList);
        if (rule != null) {
            this.addNode(root, commonSuffix, rule);
        }
        int start = 0;
        String wordForm1 = lemmaList.get(0).getWord();
        int position1 = wordForm1.length() - commonSuffix.length() - 1;
        for (int i = 0; i < lemmaList.size() - 1; ++i) {
            int position2;
            String wordForm2 = lemmaList.get(i + 1).getWord();
            if (!this.charEquals(wordForm1, position1, wordForm2, position2 = wordForm2.length() - commonSuffix.length() - 1)) {
                root = this.trainRecursive(root, lemmaList.subList(start, i + 1));
                start = i + 1;
            }
            wordForm1 = wordForm2;
            position1 = position2;
        }
        root = this.trainRecursive(root, lemmaList.subList(start, lemmaList.size()));
        return root;
    }

    private boolean charEquals(String word1, int pos1, String word2, int pos2) {
        if (pos1 < 0 || pos2 < 0) {
            return pos1 == pos2;
        }
        return word1.charAt(pos1) == word2.charAt(pos2);
    }

    private void addNode(RuleNode root, String commonSuffix, String rule) {
        if (commonSuffix.length() != 0) {
            char[] path = this.getReversedChars(commonSuffix);
            this.addRule(path, root, rule);
        }
    }

    private void addDictionaryNode(RuleNode root, String word, String lemma) {
        if (word.length() != 0) {
            char[] path = this.getReversedChars(this.endOfWordChar + word);
            this.addRule(path, root, lemma);
        }
    }

    private RuleNode addRule(char[] path, CharTrieNode root, String rule) {
        CharTrieNode current = root;
        for (int i = 0; i < path.length - 1; ++i) {
            current = this.getOrAddChild(path[i], current);
        }
        char c = path[path.length - 1];
        if (current.hasChild(c)) {
            CharTrieNode collisionNode = current.getChild(c);
            if (collisionNode instanceof RuleNode) {
                String storedRule = ((RuleNode)collisionNode).getRule();
                if (!rule.equals(storedRule)) {
                    StringBuilder suffix = new StringBuilder(path.length);
                    for (int i = path.length - 1; i >= 0; --i) {
                        suffix = suffix.append(path[i]);
                    }
                    logger.warn((Object)("Suffix " + suffix.toString() + " has rule " + storedRule + " when you are trying to add " + rule + " rule"));
                }
                return (RuleNode)collisionNode;
            }
            throw new IllegalStateException();
        }
        return (RuleNode)current.addChild(path[path.length - 1], new RuleNode(rule));
    }

    private CharTrieNode getOrAddChild(char ch, CharTrieNode current) {
        return current.hasChild(ch) ? current.getChild(ch) : current.addChild(ch, new CharTrieNode());
    }

    private char[] getReversedChars(String word) {
        return new StringBuilder(word).reverse().toString().toCharArray();
    }

    private String getCommonSuffix(List<WordLemma> lemmaList) {
        String first = lemmaList.get(0).getWord();
        String last = lemmaList.get(lemmaList.size() - 1).getWord();
        return ModelTrainer.getCommonSuffix(first, last);
    }

    private static String getCommonSuffix(String w1, String w2) {
        char[] word1 = w1.toCharArray();
        char[] word2 = w2.toCharArray();
        int minLength = Math.min(word1.length, word2.length);
        for (int i = 1; i <= minLength; ++i) {
            int c = Character.compare(word1[word1.length - i], word2[word2.length - i]);
            if (c == 0) continue;
            return w1.substring(w1.length() - (i - 1));
        }
        return w1.substring(w1.length() - minLength);
    }

    private String mostFrequentRule(String commonSuffix, List<WordLemma> lemmaList) {
        if (commonSuffix.length() == 0) {
            return "";
        }
        HashMap<String, Integer> rules = new HashMap<String, Integer>();
        int commonSuffixLength = commonSuffix.length();
        for (WordLemma wordLemma : lemmaList) {
            String rule;
            String prefix = wordLemma.getWord().substring(0, wordLemma.getWord().length() - commonSuffixLength);
            String lemma = wordLemma.getLemma();
            if (!lemma.startsWith(prefix)) continue;
            Integer count = (Integer)rules.get(rule = lemma.substring(prefix.length()));
            rules.put(rule, count == null ? 1 : count + 1);
        }
        Map.Entry mostFrequent = null;
        for (Map.Entry entry : rules.entrySet()) {
            if (mostFrequent != null && (Integer)entry.getValue() <= (Integer)mostFrequent.getValue()) continue;
            mostFrequent = entry;
        }
        if (mostFrequent == null) {
            return null;
        }
        return (String)mostFrequent.getKey();
    }

    public static class LemmaComparator
    implements Comparator<WordLemma> {
        @Override
        public int compare(WordLemma l1, WordLemma l2) {
            char[] word1 = l1.getWord().toCharArray();
            char[] word2 = l2.getWord().toCharArray();
            for (int i = 1; i <= Math.min(word1.length, word2.length); ++i) {
                int c = Character.compare(word1[word1.length - i], word2[word2.length - i]);
                if (c == 0) continue;
                return c;
            }
            return Integer.compare(word1.length, word2.length);
        }
    }

    public static class WordLemma {
        private final String word;
        private final String lemma;

        public WordLemma(String word, String lemma) {
            this.word = word;
            this.lemma = lemma;
        }

        public String getLemma() {
            return this.lemma;
        }

        public String getWord() {
            return this.word;
        }

        public String toString() {
            return "WordLemma [" + this.word + " -> " + this.lemma + "]";
        }
    }
}

