/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.lemmatizer;

import java.util.Collection;
import java.util.LinkedList;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.annotators.lemmatizer.model.CharTrieNode;
import ru.ispras.texterra.core.nlp.annotators.lemmatizer.model.LemmaGenModel;
import ru.ispras.texterra.core.nlp.annotators.lemmatizer.model.RuleNode;
import ru.ispras.texterra.core.nlp.datamodel.FastInRelationNLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.Lemma;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.relations.CoinsidesAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;

public class LemmaGenLemmatizer
implements ISerializableAnnotator<Lemma> {
    private static final long serialVersionUID = -8379012859800132745L;
    private static final IAnnotationRelationCacheBuilder CACHE_BUILDER = new CoinsidesAnnotationRelationCacheBuilder();
    private final LemmaGenModel model;
    private final char endOfWordChar;

    protected LemmaGenLemmatizer(LemmaGenModel model) {
        this.model = model;
        this.endOfWordChar = model.getEndOfWordChar();
    }

    @Override
    public Collection<Lemma> annotate(INLPDocument doc) {
        LinkedList<Lemma> result = new LinkedList<Lemma>();
        doc = new FastInRelationNLPDocument(doc, POSToken.class, IToken.class, CACHE_BUILDER);
        for (POSToken posToken : doc.getAnnotations(POSToken.class)) {
            IPOSTag posTag = (IPOSTag)posToken.getValue();
            IToken token = NLPDocumentHelper.getCoincidingAnnotation(doc, posToken, IToken.class);
            result.add(new Lemma((IAnnotation)token, this.lemmatize(token, posTag)));
        }
        return result;
    }

    private String lemmatize(IToken token, IPOSTag tag) {
        CharTrieNode root = this.model.getRootNode(tag);
        String preprocessed = this.model.getWordPreProcessor().getLemma((String)token.getValue());
        if (root == null || preprocessed.isEmpty()) {
            return preprocessed;
        }
        return this.getLemma(preprocessed, root);
    }

    private String getLemma(String word, CharTrieNode root) {
        char[] wordChars = (this.endOfWordChar + word).toCharArray();
        return this.getLemma(root, wordChars, wordChars.length - 1);
    }

    private String getLemma(CharTrieNode current, char[] wordChars, int suffixPointer) {
        char c;
        String lemma = null;
        if (suffixPointer >= 0 && current.hasChild(c = wordChars[suffixPointer])) {
            lemma = this.getLemma(current.getChild(c), wordChars, suffixPointer - 1);
        }
        if (lemma == null && current instanceof RuleNode) {
            return this.transform(wordChars, suffixPointer, ((RuleNode)current).getRule());
        }
        return lemma;
    }

    private String transform(char[] wordChars, int suffixPointer, String to) {
        StringBuilder builder = new StringBuilder();
        if (suffixPointer >= 0) {
            builder.append(wordChars, 1, suffixPointer);
        }
        builder.append(to);
        return builder.toString();
    }
}

