/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.dmb;

import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.DisambiguatedPhrase;
import ru.ispras.texterra.core.nlp.datamodel.Frame;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;

public final class MostCommonSenseDisambiguator
implements ISerializableAnnotator<DisambiguatedPhrase> {
    private static final long serialVersionUID = -5619030440756732037L;

    @Override
    public Collection<DisambiguatedPhrase> annotate(INLPDocument doc) {
        return doc.getAnnotations(Frame.class).stream().map(frame -> new DisambiguatedPhrase((IAnnotation)frame, frame.getMeanings().stream().max(new ByCommonnessComparator((Frame)frame)).get())).collect(Collectors.toList());
    }

    private static final class ByCommonnessComparator
    implements Comparator<Concept> {
        private final Frame frame;

        public ByCommonnessComparator(Frame frame) {
            this.frame = frame;
        }

        @Override
        public int compare(Concept one, Concept another) {
            return Double.compare(this.frame.getMeaningCommonness(one), this.frame.getMeaningCommonness(another));
        }
    }
}

