/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.chains;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.Validate;
import ru.ispras.ml.pipelines.SourceLabelPair;
import ru.ispras.texterra.core.nlp.annotators.chains.ChainAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;
import ru.ispras.texterra.core.nlp.utils.AnnotationUtils;

public final class InDocumentSourcesTargetsIterator<SA extends IAnnotation, TA extends IAnnotation, L>
implements Iterator<SourceLabelPair<NLPDocumentWithAnnotation<SA>, L>> {
    private final ChainAnnotator.IAnnotationLabelConverter<TA, L> converter;
    private final INLPDocument doc;
    private final Class<SA> sourceType;
    private final Class<TA> targetType;
    private final Iterator<SA> sourcesIt;
    private final Iterator<TA> targetsIt;

    public InDocumentSourcesTargetsIterator(ChainAnnotator.IAnnotationLabelConverter<TA, L> converter, INLPDocument doc, Class<SA> sourceType, Class<TA> targetType) {
        this.converter = converter;
        this.doc = doc;
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.sourcesIt = doc.getAnnotations(sourceType).iterator();
        this.targetsIt = doc.getAnnotations(targetType).iterator();
    }

    @Override
    public boolean hasNext() {
        Validate.isTrue((this.sourcesIt.hasNext() == this.targetsIt.hasNext() ? 1 : 0) != 0, (String)"Document %s has different number of %s and %s annotations.", (Object[])new Object[]{this.doc, this.sourceType.getName(), this.targetType.getName()});
        return this.sourcesIt.hasNext();
    }

    @Override
    public SourceLabelPair<NLPDocumentWithAnnotation<SA>, L> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IAnnotation source = (IAnnotation)this.sourcesIt.next();
        IAnnotation target = (IAnnotation)this.targetsIt.next();
        Validate.isTrue((boolean)AnnotationUtils.coincides(source, target), (String)"Got non coinciding annotations: %s and %s.", (Object[])new Object[]{source, target});
        L label = this.converter.convertFrom(target);
        return new SourceLabelPair(new NLPDocumentWithAnnotation<IAnnotation>(this.doc, source), label);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

