/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.chains;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import ru.ispras.ml.pipelines.PredictionPipeline;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public final class ChainAnnotator<SA extends IAnnotation, TA extends IAnnotation, L>
implements ISerializableAnnotator<TA> {
    private static final long serialVersionUID = 5811228466922781277L;
    private final PredictionPipeline<NLPDocumentWithAnnotation<SA>, L> predictor;
    private final IAnnotationLabelConverter<TA, L> converter;
    private final Class<SA> sourceType;

    protected ChainAnnotator(PredictionPipeline<NLPDocumentWithAnnotation<SA>, L> classifier, IAnnotationLabelConverter<TA, L> converter, Class<SA> sourceType) {
        this.predictor = classifier;
        this.converter = converter;
        this.sourceType = sourceType;
    }

    @Override
    public Collection<TA> annotate(INLPDocument doc) {
        ArrayList<TA> result = new ArrayList<TA>();
        INLPDocument docWithResult = doc;
        for (IAnnotation source : doc.getAnnotations(this.sourceType)) {
            Object label = this.predictor.apply(new NLPDocumentWithAnnotation<IAnnotation>(docWithResult, source)).getLabel();
            TA target = this.converter.convertTo(source, label);
            result.add(target);
            docWithResult = docWithResult.withAnnotations(Arrays.asList(target));
        }
        return result;
    }

    public static interface IAnnotationLabelConverter<A extends IAnnotation, L>
    extends Serializable {
        public A convertTo(IAnnotation var1, L var2);

        public L convertFrom(A var1);
    }
}

