/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.StopWord;

public class StopWordsAnnotator
implements ISerializableAnnotator<StopWord> {
    private static final long serialVersionUID = 937984168646709091L;
    private final Set<String> stopWords;

    public StopWordsAnnotator(Set<String> stopWords) {
        this.stopWords = stopWords;
    }

    @Override
    public Collection<StopWord> annotate(INLPDocument doc) {
        ArrayList<StopWord> res = new ArrayList<StopWord>();
        for (IToken token : doc.getAnnotations(IToken.class)) {
            if (!this.stopWords.contains(((String)token.getValue()).toLowerCase())) continue;
            res.add(new StopWord(token));
        }
        return res;
    }
}

