/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;

public final class RemovingInRelationAnnotator<SA extends IAnnotation, TA extends IAnnotation>
implements IAnnotator<TA>,
Serializable {
    private static final long serialVersionUID = -2641187327483856568L;
    private final Class<SA> sourceType;
    private final Class<TA> targetType;
    private final IAnnotationRelation relation;

    public RemovingInRelationAnnotator(Class<SA> sourceType, Class<TA> targetType, IAnnotationRelation relation) {
        this.sourceType = (Class)Validate.notNull(sourceType);
        this.targetType = (Class)Validate.notNull(targetType);
        this.relation = (IAnnotationRelation)Validate.notNull((Object)relation);
    }

    @Override
    public Collection<TA> annotate(INLPDocument doc) {
        return doc.getAnnotations(this.targetType).stream().filter(ta -> doc.getInRelationAnnotations((IAnnotation)ta, this.relation, this.sourceType).isEmpty()).collect(Collectors.toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.relation.hashCode();
        result = 31 * result + this.sourceType.hashCode();
        result = 31 * result + this.targetType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RemovingInRelationAnnotator)) {
            return false;
        }
        RemovingInRelationAnnotator other = (RemovingInRelationAnnotator)obj;
        return this.relation.equals(other.relation) && this.sourceType.equals(other.sourceType) && this.targetType.equals(other.targetType);
    }
}

