/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.MultiAnnotation;

@Deprecated
public class MultiAnnotator
implements ISerializableAnnotator<MultiAnnotation> {
    private static final long serialVersionUID = -4237123031835927904L;
    private final INLPDocument.AnnotationsComparator comparator = new INLPDocument.AnnotationsComparator();
    private final Set<Class<? extends IAnnotation>> annotationTypes;

    public MultiAnnotator(Collection<Class<? extends IAnnotation>> annotationTypes) {
        Validate.notEmpty(annotationTypes);
        this.annotationTypes = new HashSet<Class<? extends IAnnotation>>(annotationTypes);
    }

    @SafeVarargs
    public MultiAnnotator(Class<? extends IAnnotation> ... annotationTypes) {
        this(Arrays.asList(annotationTypes));
    }

    @Override
    public Collection<MultiAnnotation> annotate(INLPDocument doc) {
        Map<Class<? extends IAnnotation>, Iterator<? extends IAnnotation>> iterators = this.getIterators(doc);
        HashMap<Class<? extends IAnnotation>, IAnnotation> annotations = new HashMap<Class<? extends IAnnotation>, IAnnotation>();
        this.fetchAnnotations(annotations, iterators, this.annotationTypes);
        ArrayList<MultiAnnotation> result = new ArrayList<MultiAnnotation>();
        while (!annotations.isEmpty()) {
            Map<Class<? extends IAnnotation>, IAnnotation> value = this.extractLeastAnnotations(annotations);
            result.add(new MultiAnnotation(value.values().iterator().next(), new MultiAnnotation.MultiValue(value)));
            this.fetchAnnotations(annotations, iterators, value.keySet());
        }
        return result;
    }

    private Map<Class<? extends IAnnotation>, Iterator<? extends IAnnotation>> getIterators(INLPDocument doc) {
        HashMap<Class<? extends IAnnotation>, Iterator<? extends IAnnotation>> iterators = new HashMap<Class<? extends IAnnotation>, Iterator<? extends IAnnotation>>();
        for (Class<? extends IAnnotation> annotationType : this.annotationTypes) {
            iterators.put(annotationType, doc.getAnnotations(annotationType).iterator());
        }
        return iterators;
    }

    private void fetchAnnotations(Map<Class<? extends IAnnotation>, IAnnotation> annotations, Map<Class<? extends IAnnotation>, Iterator<? extends IAnnotation>> iterators, Set<Class<? extends IAnnotation>> types) {
        for (Class<? extends IAnnotation> type : types) {
            Iterator<? extends IAnnotation> iterator = iterators.get(type);
            if (iterator.hasNext()) {
                annotations.put(type, iterator.next());
                continue;
            }
            annotations.remove(type);
        }
    }

    private Map<Class<? extends IAnnotation>, IAnnotation> extractLeastAnnotations(Map<Class<? extends IAnnotation>, IAnnotation> annotations) {
        IAnnotation base = null;
        HashMap<Class<? extends IAnnotation>, IAnnotation> result = new HashMap<Class<? extends IAnnotation>, IAnnotation>();
        for (Map.Entry<Class<? extends IAnnotation>, IAnnotation> annotation : annotations.entrySet()) {
            int cmp = this.safeCompare(annotation.getValue(), base);
            if (cmp < 0) {
                base = annotation.getValue();
                result.clear();
            }
            if (cmp > 0) continue;
            result.put(annotation.getKey(), annotation.getValue());
        }
        return result;
    }

    private int safeCompare(IAnnotation annotation, IAnnotation base) {
        if (base == null) {
            return -1;
        }
        return this.comparator.compare(annotation, base);
    }
}

