/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.ArrayList;
import java.util.Collection;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.Lemma;
import ru.ispras.texterra.utils.lemmatizer.word.IWordLemmatizer;

public final class LemmaAnnotator
implements ISerializableAnnotator<Lemma> {
    private static final long serialVersionUID = -4615559280255165445L;
    private final IWordLemmatizer lemmatizer;

    public LemmaAnnotator(IWordLemmatizer lemmatizer) {
        this.lemmatizer = lemmatizer;
    }

    @Override
    public Collection<Lemma> annotate(INLPDocument doc) {
        ArrayList<Lemma> lemmas = new ArrayList<Lemma>();
        for (IToken token : doc.getAnnotations(IToken.class)) {
            lemmas.add(new Lemma((IAnnotation)token, this.lemmatizer.getLemma((String)token.getValue())));
        }
        return lemmas;
    }
}

