/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.Keyword;

public class KeywordsAnnotator
implements ISerializableAnnotator<Keyword> {
    private static final long serialVersionUID = -3667412311862847711L;
    private final Set<String> keywords;

    public KeywordsAnnotator(Set<String> keywords) {
        this.keywords = keywords;
    }

    @Override
    public Collection<Keyword> annotate(INLPDocument doc) {
        ArrayList<Keyword> result = new ArrayList<Keyword>();
        for (IToken token : doc.getAnnotations(IToken.class)) {
            if (!this.keywords.contains(token.getValue())) continue;
            result.add(new Keyword(token));
        }
        return result;
    }
}

