/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.Annotation;
import ru.ispras.texterra.core.nlp.datamodel.ConceptOccurrences;
import ru.ispras.texterra.core.nlp.datamodel.DisambiguatedPhrase;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;

public final class ConceptOccurrencesBuilder
implements ISerializableAnnotator<ConceptOccurrences> {
    private static final long serialVersionUID = -1866767134297889196L;

    @Override
    public Collection<ConceptOccurrences> annotate(INLPDocument doc) {
        OccurrencesStorage storage = new OccurrencesStorage(new Annotation(doc));
        for (DisambiguatedPhrase phrase : doc.getAnnotations(DisambiguatedPhrase.class)) {
            storage.addOccurence((Concept)phrase.getValue(), phrase);
        }
        return storage.build();
    }

    private static class OccurrencesStorage {
        private final IAnnotation baseAnnotation;
        private final Map<Concept, List<DisambiguatedPhrase>> conceptRepresentationsMap = new HashMap<Concept, List<DisambiguatedPhrase>>();

        public OccurrencesStorage(IAnnotation baseAnnotation) {
            this.baseAnnotation = baseAnnotation;
        }

        void addOccurence(Concept concept, DisambiguatedPhrase representation) {
            assert (((Concept)representation.getValue()).equals(concept));
            if (this.conceptRepresentationsMap.containsKey(concept)) {
                List<DisambiguatedPhrase> listRepresentations = this.conceptRepresentationsMap.get(concept);
                listRepresentations.add(representation);
            } else {
                LinkedList<DisambiguatedPhrase> listRepresentations = new LinkedList<DisambiguatedPhrase>();
                listRepresentations.add(representation);
                this.conceptRepresentationsMap.put(concept, listRepresentations);
            }
        }

        List<ConceptOccurrences> build() {
            ArrayList<ConceptOccurrences> result = new ArrayList<ConceptOccurrences>(this.conceptRepresentationsMap.size());
            for (Concept concept : this.conceptRepresentationsMap.keySet()) {
                List<DisambiguatedPhrase> listRepresentations = this.conceptRepresentationsMap.get(concept);
                ConceptOccurrences conceptoccurences = new ConceptOccurrences(this.baseAnnotation, concept, listRepresentations);
                result.add(conceptoccurences);
            }
            return result;
        }
    }
}

