/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;

public final class CoincidingAnnotator<TA extends IAnnotation>
implements IAnnotator<TA> {
    private final Class<? extends IAnnotation> sourceType;
    private final Function<IAnnotation, TA> constructor;

    public CoincidingAnnotator(Class<? extends IAnnotation> sourceType, Function<IAnnotation, TA> constructor) {
        this.sourceType = (Class)Validate.notNull(sourceType);
        this.constructor = (Function)Validate.notNull(constructor);
    }

    @Override
    public Collection<TA> annotate(INLPDocument doc) {
        return doc.getAnnotations(this.sourceType).stream().map(this.constructor).collect(Collectors.toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.constructor.hashCode();
        result = 31 * result + this.sourceType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CoincidingAnnotator)) {
            return false;
        }
        CoincidingAnnotator other = (CoincidingAnnotator)obj;
        return this.constructor.equals(other.constructor) && this.sourceType.equals(other.sourceType);
    }
}

