/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.Annotation;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;

public final class AnnotationSplitter<SA extends IAnnotation, TA extends IAnnotation>
implements ISerializableAnnotator<TA> {
    private static final long serialVersionUID = -445813276211916980L;
    private final Class<SA> sourceAnnotationType;
    private final Class<TA> targetAnnotationType;
    private final BiFunction<IAnnotation, TA, TA> annotationCreator;

    public AnnotationSplitter(Class<SA> sourceAnnotationType, Class<TA> targetAnnotationClass, Function<IAnnotation, TA> annotationConstructor) {
        this(sourceAnnotationType, targetAnnotationClass, (IAnnotation bounds, TA old) -> (IAnnotation)annotationConstructor.apply((IAnnotation)bounds));
    }

    public AnnotationSplitter(Class<SA> sourceAnnotationType, Class<TA> targetAnnotationType, BiFunction<IAnnotation, TA, TA> annotationCreator) {
        this.sourceAnnotationType = (Class)Validate.notNull(sourceAnnotationType);
        this.targetAnnotationType = (Class)Validate.notNull(targetAnnotationType);
        this.annotationCreator = (BiFunction)Validate.notNull(annotationCreator);
    }

    @Override
    public Collection<TA> annotate(INLPDocument doc) {
        List<SA> sourceAnnotations = doc.getAnnotations(this.sourceAnnotationType);
        int[] splitPoints = this.getSplitPoints(sourceAnnotations);
        List<TA> targetAnnotations = doc.getAnnotations(this.targetAnnotationType);
        return targetAnnotations.stream().flatMap(target -> this.split(doc, target, splitPoints)).collect(Collectors.toList());
    }

    private int[] getSplitPoints(List<SA> sourceAnnotations) {
        TIntHashSet boundaries = new TIntHashSet(sourceAnnotations.size() * 2);
        for (IAnnotation sourceAnnotation : sourceAnnotations) {
            boundaries.add(sourceAnnotation.getStart());
            boundaries.add(sourceAnnotation.getEnd());
        }
        int[] result = boundaries.toArray();
        Arrays.sort(result);
        return result;
    }

    private Stream<TA> split(INLPDocument doc, TA target, int[] splitPoints) {
        ArrayList result = new ArrayList();
        int startSplitIndex = this.getSplitPointIndex(splitPoints, target.getStart());
        int previousSplit = target.getStart();
        for (int i = startSplitIndex; i < splitPoints.length && previousSplit < target.getEnd(); ++i) {
            int splitPoint = splitPoints[i];
            this.createAnnotation(doc, target, previousSplit, splitPoint).ifPresent(result::add);
            previousSplit = splitPoint;
        }
        this.createAnnotation(doc, target, previousSplit, target.getEnd()).ifPresent(result::add);
        return result.stream();
    }

    private Optional<TA> createAnnotation(INLPDocument doc, TA targetAnnotation, int start, int end) {
        int annotationEnd;
        int annotationStart = Math.max(start, targetAnnotation.getStart());
        if (annotationStart >= (annotationEnd = Math.min(end, targetAnnotation.getEnd()))) {
            return Optional.empty();
        }
        if (annotationStart == targetAnnotation.getStart() && annotationEnd == targetAnnotation.getEnd()) {
            return Optional.of(targetAnnotation);
        }
        return Optional.of(this.annotationCreator.apply(new Annotation(doc, annotationStart, annotationEnd), targetAnnotation));
    }

    private int getSplitPointIndex(int[] sortedSplitPoints, int key) {
        int result = Arrays.binarySearch(sortedSplitPoints, key);
        return result >= 0 ? result + 1 : -result - 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.annotationCreator.hashCode();
        result = 31 * result + this.sourceAnnotationType.hashCode();
        result = 31 * result + this.targetAnnotationType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AnnotationSplitter)) {
            return false;
        }
        AnnotationSplitter other = (AnnotationSplitter)obj;
        return this.annotationCreator.equals(other.annotationCreator) && this.sourceAnnotationType.equals(other.sourceAnnotationType) && this.targetAnnotationType.equals(other.targetAnnotationType);
    }
}

