/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;

public abstract class AbstractRegexBasedAnnotator<T extends IAnnotation>
implements ISerializableAnnotator<T> {
    private static final long serialVersionUID = 638560360037508570L;
    protected Pattern regex;

    protected AbstractRegexBasedAnnotator(Pattern regex) {
        this.regex = regex;
    }

    protected abstract T annotateToken(IToken var1);

    @Override
    public Collection<T> annotate(INLPDocument doc) {
        LinkedList<T> res = new LinkedList<T>();
        for (IToken token : doc.getAnnotations(IToken.class)) {
            if (!this.regex.matcher((CharSequence)token.getValue()).matches()) continue;
            res.add(this.annotateToken(token));
        }
        return res;
    }
}

