/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.ekb.similarity.candidatfilter;

import java.util.ArrayList;
import java.util.List;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarCandidatesFilter;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarityComputer;

public final class TopPercentCandidatesFilter
implements ISimilarCandidatesFilter {
    private static final long serialVersionUID = -812668287728220365L;
    private final double portion;

    public TopPercentCandidatesFilter(double p) {
        this.portion = p;
    }

    @Override
    public List<ISimilarityComputer.ConceptWithSimilarity> selectCandidates(List<ISimilarityComputer.ConceptWithSimilarity> candidates) {
        int threshold = (int)(this.portion * (double)candidates.size());
        if (candidates.size() <= threshold) {
            return candidates;
        }
        return new ArrayList<ISimilarityComputer.ConceptWithSimilarity>(candidates.subList(0, threshold));
    }
}

