/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.ekb.similarity.candidatfilter;

import java.util.ArrayList;
import java.util.List;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarCandidatesFilter;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarityComputer;

public class SimilarityThresholdCandidatesFilter
implements ISimilarCandidatesFilter {
    private static final long serialVersionUID = -5850806452331790508L;
    private final double similarityThreshold;

    public SimilarityThresholdCandidatesFilter(double threshold) {
        this.similarityThreshold = threshold;
    }

    @Override
    public List<ISimilarityComputer.ConceptWithSimilarity> selectCandidates(List<ISimilarityComputer.ConceptWithSimilarity> candidates) {
        ArrayList<ISimilarityComputer.ConceptWithSimilarity> result = new ArrayList<ISimilarityComputer.ConceptWithSimilarity>(candidates.size());
        for (ISimilarityComputer.ConceptWithSimilarity cws : candidates) {
            if (!(cws.getSimilarity() >= this.similarityThreshold)) break;
            result.add(cws);
        }
        return result;
    }
}

