/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.ekb.interfaces;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.Element;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.ekb.interfaces.ILinkWeightComputer;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarCandidatesFilter;
import ru.ispras.texterra.core.ekb.similarity.FullSimilarityGraph;

public interface ISimilarityComputer {
    public double[] allPairsSimilarity(List<Concept> var1, Collection<Concept> var2, ILinkWeightComputer var3);

    public double[] allPairsSimilarity(List<Concept> var1, Map<Concept, Double> var2, ILinkWeightComputer var3);

    public double[] relatednessToContext(List<Concept> var1, Collection<Concept> var2, ILinkWeightComputer var3);

    public double relatednessBetweenGroups(Collection<Concept> var1, Collection<Concept> var2, ILinkWeightComputer var3);

    public FullSimilarityGraph computeFullSimilarityGraph(List<Concept> var1, ILinkWeightComputer var2);

    public double computeSimilarity(Concept var1, Concept var2, ILinkWeightComputer var3);

    public List<ConceptWithSimilarity> getSimilarAmongFirstNeighbors(Concept var1, ILinkWeightComputer var2, int var3);

    public List<ConceptWithSimilarity> getSimilarAmongAll(Concept var1, ILinkWeightComputer var2, int var3);

    public List<ConceptWithSimilarity> getSimilar(Concept var1, ISimilarCandidatesFilter var2, ILinkWeightComputer var3, int var4);

    public List<ConceptWithSimilarity> getSimilar(Collection<Concept> var1, ILinkWeightComputer var2, ISimilarCandidatesFilter var3, int var4);

    public List<ConceptWithSimilarity> getSimilar(Collection<Concept> var1, ILinkWeightComputer var2, int var3);

    public static class ConceptWithSimilarity
    implements Serializable,
    Comparable<ConceptWithSimilarity> {
        private static final long serialVersionUID = 105672892625527264L;
        @Element(name="concept")
        private final Concept concept;
        @Element(name="weight")
        private final double weight;

        public ConceptWithSimilarity(@Element(name="concept") Concept c, @Element(name="weight") double w) {
            this.concept = c;
            this.weight = w;
        }

        public Concept getConcept() {
            return this.concept;
        }

        public double getSimilarity() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (o instanceof ConceptWithSimilarity) {
                return ((ConceptWithSimilarity)o).getConcept().equals(this.getConcept());
            }
            return false;
        }

        public int hashCode() {
            return this.getConcept().hashCode();
        }

        @Override
        public int compareTo(ConceptWithSimilarity other) {
            return Double.compare(other.weight, this.weight);
        }

        public String toString() {
            return "<" + this.concept.getKbName() + ":" + this.concept.getId() + ", " + this.weight + ">";
        }
    }
}

