/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.configuration.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import ru.ispras.texterra.core.configuration.provider.IConfigurationProvider;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;

abstract class LineSplittingConfigurationProvider
implements IConfigurationProvider {
    LineSplittingConfigurationProvider() {
    }

    public Collection<HierarchicalConfiguration> createConfigurations() throws TexterraConfigException {
        String files = this.getFilesLine();
        ArrayList<HierarchicalConfiguration> result = new ArrayList<HierarchicalConfiguration>();
        if (files == null || files.isEmpty()) {
            return result;
        }
        String separator = System.getProperty("path.separator");
        for (String path : files.split(separator)) {
            if (path.isEmpty()) continue;
            try {
                XMLConfiguration config = new XMLConfiguration();
                config.load(new File(path));
                result.add((HierarchicalConfiguration)config);
            }
            catch (ConfigurationException e) {
                throw new TexterraConfigException(e);
            }
        }
        return result;
    }

    protected abstract String getFilesLine();
}

