/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.configuration.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.HierarchicalConfiguration;
import ru.ispras.texterra.core.configuration.provider.IConfigurationProvider;

public final class FromSystemPropertiesConfigurationProvider
implements IConfigurationProvider {
    private final String prefix;

    public FromSystemPropertiesConfigurationProvider() {
        this("");
    }

    public FromSystemPropertiesConfigurationProvider(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Collection<? extends HierarchicalConfiguration> createConfigurations() {
        HierarchicalConfiguration result = new HierarchicalConfiguration();
        for (Map.Entry<String, Object> propertyValue : this.extractTexterraProperties().entrySet()) {
            result.addProperty(propertyValue.getKey(), propertyValue.getValue());
        }
        return Collections.singletonList(result);
    }

    private Map<String, Object> extractTexterraProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(this.prefix)) continue;
            result.put(key, properties.get(key));
        }
        return result;
    }

    @Override
    public String getConfigurationSourceDescription() {
        return "System properties, prefixed with '" + this.prefix + "': " + this.extractTexterraProperties();
    }
}

