/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.configuration.provider;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import ru.ispras.texterra.core.configuration.provider.IConfigurationProvider;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;

public final class FromFileConfigurationProvider
implements IConfigurationProvider {
    private final String path;

    public FromFileConfigurationProvider(String path) {
        this.path = path;
    }

    @Override
    public Collection<? extends HierarchicalConfiguration> createConfigurations() throws TexterraConfigException {
        try {
            XMLConfiguration config = new XMLConfiguration();
            config.load(new File(this.path));
            return Collections.singletonList(config);
        }
        catch (ConfigurationException e) {
            throw new TexterraConfigException(e);
        }
    }

    @Override
    public String getConfigurationSourceDescription() {
        return "File: '" + this.path + "'";
    }
}

