/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.configuration;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.log4j.Logger;
import ru.ispras.texterra.core.configuration.provider.IConfigurationProvider;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;

public final class TexterraConfiguration {
    public static final String NO_SCOPE = null;
    private static final String SCOPE = "scope";
    private final List<HierarchicalConfiguration> configurations;

    TexterraConfiguration(List<? extends IConfigurationProvider> configurationProviders) throws TexterraConfigException {
        this(configurationProviders.toArray(new IConfigurationProvider[0]));
    }

    TexterraConfiguration(IConfigurationProvider ... configurationProviders) throws TexterraConfigException {
        this.configurations = new ArrayList<HierarchicalConfiguration>(configurationProviders.length);
        for (IConfigurationProvider provider : configurationProviders) {
            Logger.getLogger(TexterraConfiguration.class).debug((Object)("Reading configuration part from:\n  " + provider.getConfigurationSourceDescription()));
            Collection<? extends HierarchicalConfiguration> subConfigurations = provider.createConfigurations();
            for (HierarchicalConfiguration hierarchicalConfiguration : subConfigurations) {
                hierarchicalConfiguration.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
                this.configurations.add(hierarchicalConfiguration);
            }
        }
    }

    public Set<String> getScopes(Class<?> clazz) {
        HashSet<String> scopes = new HashSet<String>();
        String key = this.getKey(clazz);
        for (HierarchicalConfiguration subConfiguration : this.configurations) {
            List classConfigurations = subConfiguration.configurationsAt(key);
            for (HierarchicalConfiguration classConfiguration : classConfigurations) {
                scopes.addAll(this.extractScopes(classConfiguration));
            }
        }
        return scopes;
    }

    private List<String> extractScopes(HierarchicalConfiguration classConfiguration) {
        List scopeAttributes = classConfiguration.getRoot().getAttributes(SCOPE);
        ArrayList<String> scopes = new ArrayList<String>(scopeAttributes.size());
        for (ConfigurationNode node : scopeAttributes) {
            scopes.add(node.getValue().toString());
        }
        if (scopes.isEmpty()) {
            scopes.add(NO_SCOPE);
        }
        return scopes;
    }

    public List<TexterraClassProperties> getScopedOrDefaultAllClassProperties(Class<?> clazz, String scope) {
        return this.getAllClassPropertiesInScopes(clazz, scope, NO_SCOPE);
    }

    public List<TexterraClassProperties> getAllClassProperties(Class<?> clazz, String scope) {
        return this.getAllClassPropertiesInScopes(clazz, scope);
    }

    private List<TexterraClassProperties> getAllClassPropertiesInScopes(Class<?> clazz, String ... scopes) {
        return this.getAllClassPropertiesInScopes(clazz, new TrueClassPropertiesFilter(), scopes);
    }

    private List<TexterraClassProperties> getAllClassPropertiesInScopes(Class<?> clazz, IClassPropertiesFilter filter, String ... scopes) {
        for (HierarchicalConfiguration subConfiguration : this.configurations) {
            for (String scope : scopes) {
                String key = this.getKey(clazz, scope);
                List classConfigurations = subConfiguration.configurationsAt(key);
                List<TexterraClassProperties> resultCandidate = this.extractListOfClassProperties(classConfigurations, filter, clazz, scope);
                if (resultCandidate.isEmpty()) continue;
                return resultCandidate;
            }
        }
        return Collections.emptyList();
    }

    private List<TexterraClassProperties> extractListOfClassProperties(List<HierarchicalConfiguration> classConfigurations, IClassPropertiesFilter filter, Class<?> clazz, String scope) {
        ArrayList<TexterraClassProperties> result = new ArrayList<TexterraClassProperties>();
        for (HierarchicalConfiguration classConfiguration : classConfigurations) {
            Map<String, List<String>> classProperties = this.extractProperties(classConfiguration);
            TexterraClassProperties properties = new TexterraClassProperties(classProperties, clazz, scope);
            if (!filter.accept(properties)) continue;
            result.add(properties);
        }
        return result;
    }

    private Map<String, List<String>> extractProperties(HierarchicalConfiguration classConfiguration) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Iterator keys = classConfiguration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (this.isAttribute(key)) continue;
            String[] values = classConfiguration.getStringArray(key);
            result.put(key, new ArrayList<String>(Arrays.asList(values)));
        }
        return result;
    }

    private boolean isAttribute(String property) {
        return property.startsWith("@");
    }

    public TexterraClassProperties getSingleClassProperties(Class<?> clazz, String scope) throws TexterraConfigException {
        List<TexterraClassProperties> perClassProperties = this.getAllClassProperties(clazz, scope);
        return this.getSingleClassProperties(perClassProperties, clazz, scope);
    }

    public TexterraClassProperties getScopedOrDefaultSingleClassProperties(Class<?> clazz, String scope) throws TexterraConfigException {
        List<TexterraClassProperties> perClassProperties = this.getScopedOrDefaultAllClassProperties(clazz, scope);
        return this.getSingleClassProperties(perClassProperties, clazz, scope);
    }

    private TexterraClassProperties getSingleClassProperties(List<TexterraClassProperties> perClassProperties, Class<?> clazz, String scope) throws TexterraConfigException {
        if (perClassProperties.isEmpty()) {
            throw new TexterraConfigException("No properties found for class: " + clazz.getName() + " scope: " + scope);
        }
        return perClassProperties.get(0);
    }

    public List<String> getAllProperties(Class<?> clazz, String property, String scope) {
        List<TexterraClassProperties> classProperties = this.getAllClassPropertiesInScopes(clazz, new HasPropertyClassPropertiesFilter(property), scope);
        return this.getAllProperties(classProperties, property);
    }

    public List<String> getScopedOrDefaultAllProperties(Class<?> clazz, String property, String scope) {
        List<TexterraClassProperties> classProperties = this.getAllClassPropertiesInScopes(clazz, new HasPropertyClassPropertiesFilter(property), scope, NO_SCOPE);
        return this.getAllProperties(classProperties, property);
    }

    private List<String> getAllProperties(List<TexterraClassProperties> classProperties, String property) {
        ArrayList<String> result = new ArrayList<String>();
        for (TexterraClassProperties singleClassProperties : classProperties) {
            if (!singleClassProperties.contains(property)) continue;
            List<String> partialResult = singleClassProperties.getValues(property);
            result.addAll(partialResult);
        }
        return result;
    }

    public String getSingleProperty(Class<?> clazz, String property, String scope) throws TexterraConfigException {
        List<String> values = this.getAllProperties(clazz, property, scope);
        return this.getSingleProperty(values, clazz, property, scope);
    }

    public String getScopedOrDefaultSingleProperty(Class<?> clazz, String property, String scope) throws TexterraConfigException {
        List<String> values = this.getScopedOrDefaultAllProperties(clazz, property, scope);
        return this.getSingleProperty(values, clazz, property, scope);
    }

    private String getSingleProperty(List<String> values, Class<?> clazz, String property, String scope) throws TexterraConfigException {
        if (values.isEmpty()) {
            throw new TexterraConfigException("No such property. Class: " + clazz.getName() + " property: " + property + " scope: " + scope);
        }
        return values.get(0);
    }

    public String getStringProperty(Class<?> clazz, String property) {
        return this.getScopedOrDefaultSingleProperty(clazz, property, NO_SCOPE);
    }

    public String getStringProperty(Class<?> clazz, String property, String scope) {
        return this.getScopedOrDefaultSingleProperty(clazz, property, scope);
    }

    public boolean getBoolProperty(Class<?> clazz, String property) {
        return this.getBoolProperty(clazz, property, NO_SCOPE);
    }

    public boolean getBoolProperty(Class<?> clazz, String property, String scope) {
        return Boolean.parseBoolean(this.getScopedOrDefaultSingleProperty(clazz, property, scope));
    }

    public int getIntProperty(Class<?> clazz, String property) {
        return this.getIntProperty(clazz, property, NO_SCOPE);
    }

    public int getIntProperty(Class<?> clazz, String property, String scope) {
        return Integer.parseInt(this.getScopedOrDefaultSingleProperty(clazz, property, scope));
    }

    public double getDoubleProperty(Class<?> clazz, String property) {
        return Double.parseDouble(this.getScopedOrDefaultSingleProperty(clazz, property, NO_SCOPE));
    }

    public double getDoubleProperty(Class<?> clazz, String property, String scope) {
        return Double.parseDouble(this.getScopedOrDefaultSingleProperty(clazz, property, scope));
    }

    private String getKey(Class<?> clazz, String scope) {
        String key = this.getKey(clazz);
        key = scope == NO_SCOPE ? key + "[not(@scope)]" : key + "[@scope=\"" + scope + "\"]";
        return key;
    }

    private String getKey(Class<?> clazz) {
        String key = clazz.getName().replaceAll("\\.", "/");
        return key;
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new TexterraSystemException(e);
        }
    }

    private class HasPropertyClassPropertiesFilter
    implements IClassPropertiesFilter {
        private String property;

        public HasPropertyClassPropertiesFilter(String property) {
            this.property = property;
        }

        @Override
        public boolean accept(TexterraClassProperties properties) {
            return properties.contains(this.property);
        }
    }

    private class TrueClassPropertiesFilter
    implements IClassPropertiesFilter {
        private TrueClassPropertiesFilter() {
        }

        @Override
        public boolean accept(TexterraClassProperties properties) {
            return true;
        }
    }

    private static interface IClassPropertiesFilter {
        public boolean accept(TexterraClassProperties var1);
    }

    public class TexterraClassProperties {
        private Map<String, List<String>> propertyToValues;
        private Class<?> clazz;
        private String scope;

        public TexterraClassProperties(Map<String, List<String>> properties, Class<?> clazz, String scope) {
            this.propertyToValues = properties;
            this.clazz = clazz;
            this.scope = scope;
        }

        public List<String> getValues(String property) {
            return this.propertyToValues.get(property);
        }

        public boolean contains(String property) {
            return this.propertyToValues.containsKey(property);
        }

        public int size() {
            return this.propertyToValues.size();
        }

        public String getValue(String property) {
            if (this.contains(property)) {
                return this.getValues(property).get(0);
            }
            return TexterraConfiguration.this.getStringProperty(this.clazz, property, this.scope);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.propertyToValues == null ? 0 : this.propertyToValues.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TexterraClassProperties)) {
                return false;
            }
            TexterraClassProperties other = (TexterraClassProperties)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.propertyToValues == null ? other.propertyToValues != null : !this.propertyToValues.equals(other.propertyToValues));
        }

        private TexterraConfiguration getOuterType() {
            return TexterraConfiguration.this;
        }
    }
}

