/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie;

import java.util.Collections;
import java.util.List;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.LemmaSuggestion;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.StemSuffix;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.TrieNode;

public class TriePath {
    private List<TrieNode> nodes;
    private int expectedLength;
    private StemSuffix stemSuffix;

    public TriePath(List<TrieNode> path, StemSuffix stemSuffix, int expectedPathLenght) {
        this.nodes = path;
        this.stemSuffix = stemSuffix;
        this.expectedLength = expectedPathLenght;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    private boolean isFullPath() {
        return this.nodes.size() == this.expectedLength;
    }

    public List<LemmaSuggestion> getLemmasForExactStemMatch() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        TrieNode lastNodeInPath = this.nodes.get(this.nodes.size() - 1);
        if (this.isFullPath()) {
            return lastNodeInPath.getSuggestionsForStemAndSuffix(this.stemSuffix);
        }
        return Collections.emptyList();
    }

    public List<LemmaSuggestion> getLemmasUsingMostSimilarStems() {
        TrieNode currentNode;
        List<LemmaSuggestion> result = Collections.emptyList();
        for (int i = this.nodes.size() - 1; i >= 0 && (result = (currentNode = this.nodes.get(i)).getSuggestionsFromAllDescendantsWithInflectModel(this.stemSuffix)).isEmpty(); --i) {
        }
        return result;
    }
}

