/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.utils.language.ITexterraLanguage;
import ru.ispras.texterra.utils.language.RussianLanguage;
import ru.ispras.texterra.utils.lemmatizer.TexterraLemmatizerException;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ModelBasedLanguageDependentWordLemmatizer;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.ILemmaSuggestionChooser;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.LemmaSuggestion;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.LengthBasedChooser;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.StemSuffix;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.StemSuffixPairsForWordComputer;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.StemTrie;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.TriePath;

public class RussianWordLemmatizer
extends ModelBasedLanguageDependentWordLemmatizer {
    private static final long serialVersionUID = -3266800116765200709L;
    @ConfigurationProperty
    private static final String suffixesFileNameProperty = "suffixes";
    private static final String suffixesFileName = TexterraConfigurationFactory.getConfiguration().getStringProperty(RussianWordLemmatizer.class, "suffixes");
    @ConfigurationProperty
    private static final String dictionaryFileNameProperty = "dictionary";
    private static final String dictionaryFileName = TexterraConfigurationFactory.getConfiguration().getStringProperty(RussianWordLemmatizer.class, "dictionary");
    private static final int TRIE_ROOT_LEN = 2;
    private static RussianWordLemmatizer instance;
    private final StemTrie stemTrie;
    private final StemSuffixPairsForWordComputer stemSuffixPairsComputer;
    private final ILemmaSuggestionChooser suggestionChooser;

    public static RussianWordLemmatizer getInstance() throws TexterraLemmatizerException {
        if (instance == null) {
            instance = new RussianWordLemmatizer();
        }
        return instance;
    }

    public String getLemma(String word) {
        return this.computeLemmaInLowerCase(word);
    }

    protected RussianWordLemmatizer() throws TexterraLemmatizerException {
        super((ITexterraLanguage)new RussianLanguage());
        try {
            this.suggestionChooser = new LengthBasedChooser();
            this.stemSuffixPairsComputer = new StemSuffixPairsForWordComputer(this.getResource(suffixesFileName), 2);
            this.stemTrie = new StemTrie(this.getResource(dictionaryFileName), 2);
        }
        catch (IOException e) {
            throw new TexterraLemmatizerException(e);
        }
    }

    private String computeLemmaInLowerCase(String word) {
        String lowerCaseWord = word.toLowerCase();
        if (lowerCaseWord.length() > 2) {
            Set<LemmaSuggestion> suggestions = this.getSuggestions(lowerCaseWord);
            return this.suggestionChooser.chooseSuggestion(suggestions);
        }
        return lowerCaseWord;
    }

    private Set<LemmaSuggestion> getSuggestions(String word) {
        List<StemSuffix> stemSuffixes = this.stemSuffixPairsComputer.getPossibleStemSuffixPairs(word);
        Set<LemmaSuggestion> result = this.getSuggestionsForStemSuffixes(stemSuffixes);
        if (result.isEmpty()) {
            result.add(new LemmaSuggestion(word, "", ""));
        }
        return result;
    }

    private Set<LemmaSuggestion> getSuggestionsForStemSuffixes(List<StemSuffix> stemSuffixes) {
        LinkedHashSet<LemmaSuggestion> result = new LinkedHashSet<LemmaSuggestion>();
        for (StemSuffix currentStemSuffix : stemSuffixes) {
            TriePath path = this.stemTrie.getTriePathForStem(currentStemSuffix);
            if (path.isEmpty()) continue;
            List<LemmaSuggestion> dictionaryForms = path.getLemmasForExactStemMatch();
            if (!dictionaryForms.isEmpty()) {
                return new LinkedHashSet<LemmaSuggestion>(dictionaryForms);
            }
            List<LemmaSuggestion> normalForms = path.getLemmasUsingMostSimilarStems();
            result.addAll(normalForms);
        }
        return result;
    }
}

