/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import ru.ispras.texterra.utils.language.ITexterraLanguage;
import ru.ispras.texterra.utils.lemmatizer.word.IWordLemmatizer;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ILanguageDependentWordLemmatizer;

public class MultiLanguageLemmatizer
implements IWordLemmatizer {
    private static final long serialVersionUID = -4317263765544735162L;
    private final Map<ITexterraLanguage, ILanguageDependentWordLemmatizer> lang2lemmatizer = new LinkedHashMap<ITexterraLanguage, ILanguageDependentWordLemmatizer>();

    public MultiLanguageLemmatizer(List<? extends ILanguageDependentWordLemmatizer> lemmatizers) {
        for (ILanguageDependentWordLemmatizer iLanguageDependentWordLemmatizer : lemmatizers) {
            this.lang2lemmatizer.put(iLanguageDependentWordLemmatizer.getLanguage(), iLanguageDependentWordLemmatizer);
        }
    }

    public String getLemma(String word) {
        for (Map.Entry<ITexterraLanguage, ILanguageDependentWordLemmatizer> entry : this.lang2lemmatizer.entrySet()) {
            if (!this.checkWordLanguage(entry.getKey(), word)) continue;
            return entry.getValue().getLemma(word);
        }
        return word;
    }

    private boolean checkWordLanguage(ITexterraLanguage language, String word) {
        Matcher matcher = language.getAlphabet().matcher(word);
        return matcher.matches();
    }
}

