/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import ru.ispras.modis.utils.ClasspathUtils;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.utils.language.ITexterraLanguage;
import ru.ispras.texterra.utils.lemmatizer.TexterraLemmatizerException;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.LanguageDependentWordLemmatizer;

public abstract class ModelBasedLanguageDependentWordLemmatizer
extends LanguageDependentWordLemmatizer {
    private static final long serialVersionUID = -1587500099419101396L;
    @ConfigurationProperty
    private static final String modelPathProperty = "modelPath";
    private final String modelPath;

    protected ModelBasedLanguageDependentWordLemmatizer(ITexterraLanguage language) {
        super(language);
        this.modelPath = ModelBasedLanguageDependentWordLemmatizer.getModelPath(language);
    }

    private static String getModelPath(ITexterraLanguage language) {
        try {
            return TexterraConfigurationFactory.getConfiguration().getStringProperty(ModelBasedLanguageDependentWordLemmatizer.class, modelPathProperty, language.getLanguageTag());
        }
        catch (NoSuchElementException e) {
            throw new TexterraLemmatizerException("Lemmatizer tries to use model, but there is no model path property " + LanguageDependentWordLemmatizer.class.getCanonicalName() + "." + modelPathProperty + " for " + language.getLanguageTag() + " scope.");
        }
    }

    protected final InputStream getResource(String fileName) throws TexterraLemmatizerException {
        try {
            return ClasspathUtils.getResourceAsStream((String)this.modelPath, (String)fileName);
        }
        catch (IOException e) {
            throw new TexterraLemmatizerException("Can't load model " + fileName, e);
        }
    }
}

