/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.factory;

import java.util.Arrays;
import java.util.List;
import ru.ispras.texterra.utils.lemmatizer.factory.ILemmatizerFactory;
import ru.ispras.texterra.utils.lemmatizer.word.CompositeWordLemmatizer;
import ru.ispras.texterra.utils.lemmatizer.word.IWordLemmatizer;
import ru.ispras.texterra.utils.lemmatizer.word.PunctuationLemmatizer;
import ru.ispras.texterra.utils.lemmatizer.word.UppercaseLemmatizer;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ILanguageDependentWordLemmatizer;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.MultiLanguageLemmatizer;

public abstract class MultilanguageLemmatizerFactory
implements ILemmatizerFactory {
    private final List<ILanguageDependentWordLemmatizer> lemmatizers;

    protected MultilanguageLemmatizerFactory(ILanguageDependentWordLemmatizer ... lemmatizers) {
        this.lemmatizers = Arrays.asList(lemmatizers);
    }

    @Override
    public IWordLemmatizer createWordLemmatizer() {
        return new CompositeWordLemmatizer(new IWordLemmatizer[]{this.getPretreatmentLemmatizer(), this.getPrimaryLemmatizer(), this.getPosttreatmentLemmatizer()});
    }

    protected IWordLemmatizer getPretreatmentLemmatizer() {
        return new PunctuationLemmatizer();
    }

    protected IWordLemmatizer getPosttreatmentLemmatizer() {
        return new UppercaseLemmatizer();
    }

    private IWordLemmatizer getPrimaryLemmatizer() {
        return new MultiLanguageLemmatizer(this.lemmatizers);
    }
}

