/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.base.annotators.language;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import ru.ispras.modis.utils.ClasspathUtils;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.utils.language.ITexterraLanguage;
import ru.ispras.texterra.utils.language.RussianLanguage;
import ru.ispras.texterra.utils.language.TexterraLanguagesManager;

@Deprecated
public class CybozuLanguageDetector
implements IAnnotator<ru.ispras.texterra.core.nlp.datamodel.Language> {
    private static volatile CybozuLanguageDetector instance;
    @ConfigurationProperty
    private static final String profilesPathProperty = "profilesPath";
    private static final String profilesPath;
    private final HashMap<String, Double> priorProbabilities = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CybozuLanguageDetector getInstance() {
        if (instance != null) return instance;
        Class<CybozuLanguageDetector> clazz = CybozuLanguageDetector.class;
        synchronized (CybozuLanguageDetector.class) {
            if (instance != null) return instance;
            instance = new CybozuLanguageDetector();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CybozuLanguageDetector() {
        TexterraLanguagesManager.getSupportedLanguages().stream().map(ITexterraLanguage::getLanguageTag).forEach(lang -> this.priorProbabilities.put((String)lang, 1.0));
        String tempProfilesPath = this.prepareTempProfiles();
        try {
            DetectorFactory.loadProfile((String)tempProfilesPath);
        }
        catch (LangDetectException e) {
            throw new TexterraSystemException((Throwable)e);
        }
    }

    private String prepareTempProfiles() {
        String tempProfilesPath = System.getProperty("java.io.tmpdir") + File.separatorChar + profilesPath;
        new File(tempProfilesPath).mkdirs();
        try (ZipInputStream profiles = new ZipInputStream(ClasspathUtils.getResourceAsStream((String)profilesPath));){
            ZipEntry entry;
            while ((entry = profiles.getNextEntry()) != null) {
                this.prepareTempProfile(tempProfilesPath, profiles, entry);
                profiles.closeEntry();
            }
        }
        catch (IOException e) {
            throw new TexterraSystemException((Throwable)e);
        }
        return tempProfilesPath;
    }

    private void prepareTempProfile(String tempProfilesPath, ZipInputStream profiles, ZipEntry entry) throws IOException {
        try (FileOutputStream profile = new FileOutputStream(tempProfilesPath + File.separatorChar + entry.getName());){
            IOUtils.copy((InputStream)profiles, (OutputStream)profile);
        }
    }

    public Collection<ru.ispras.texterra.core.nlp.datamodel.Language> annotate(INLPDocument doc) {
        RussianLanguage language;
        List<Language> langs = this.getLangsFromCybozu(doc.getText());
        if (langs == null) {
            language = new RussianLanguage();
        } else {
            if (this.noWinner(langs)) {
                throw new TexterraSystemException("Couldn't determine any supported language.");
            }
            language = TexterraLanguagesManager.getTexterraLanguage((String)langs.get((int)0).lang);
        }
        return Collections.singleton(new ru.ispras.texterra.core.nlp.datamodel.Language(doc, (ITexterraLanguage)language));
    }

    private List<Language> getLangsFromCybozu(String text) {
        Detector detector;
        try {
            detector = DetectorFactory.create();
            detector.setPriorMap(this.priorProbabilities);
            detector.append(text);
        }
        catch (LangDetectException e) {
            throw new TexterraSystemException((Throwable)e);
        }
        try {
            return detector.getProbabilities();
        }
        catch (LangDetectException e) {
            return null;
        }
    }

    private boolean noWinner(List<Language> langs) {
        return langs.isEmpty() || langs.stream().map(lang -> lang.prob).allMatch(prob -> prob < 0.5);
    }

    static {
        profilesPath = TexterraConfigurationFactory.getConfiguration().getStringProperty(CybozuLanguageDetector.class, profilesPathProperty);
    }
}

