/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos.opennlp;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerME;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSTokenFactory;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.MorphPropertiesTagFactory;

public class OpenNLPPOSTagger
implements ISerializableAnnotator<POSToken> {
    private static final long serialVersionUID = -6921915851268331535L;
    private transient POSModel posModel;
    private final POSTokenFactory posTokenFactory;

    protected OpenNLPPOSTagger(MorphPropertiesTagFactory posTagFactory, POSModel posModel) {
        this.posTokenFactory = new POSTokenFactory(posTagFactory);
        this.posModel = posModel;
    }

    public Collection<POSToken> annotate(INLPDocument doc) {
        POSTaggerME tagger = new POSTaggerME(this.posModel);
        LinkedList<POSToken> result = new LinkedList<POSToken>();
        for (Sentence sentence : doc.getAnnotations(Sentence.class)) {
            List sentenceTokens = NLPDocumentHelper.getContainedAnnotations((INLPDocument)doc, (IAnnotation)sentence, IToken.class);
            List<String> sentencePoSTags = this.getSentenceTags((POSTagger)tagger, sentenceTokens);
            result.addAll(this.collectSentencePOSTokens(sentenceTokens, sentencePoSTags));
        }
        return result;
    }

    private List<POSToken> collectSentencePOSTokens(List<IToken> sentenceTokens, List<String> sentencePosTags) {
        assert (sentenceTokens.size() == sentencePosTags.size());
        ArrayList<POSToken> result = new ArrayList<POSToken>(sentenceTokens.size());
        for (int i = 0; i < sentenceTokens.size(); ++i) {
            IToken token = sentenceTokens.get(i);
            String tag = sentencePosTags.get(i);
            result.add(this.posTokenFactory.createPOSToken(token, tag));
        }
        return result;
    }

    protected List<String> getSentenceTags(POSTagger tagger, List<IToken> sentenceTokens) {
        return Arrays.asList(tagger.tag(this.getSentenceText(sentenceTokens).toArray(new String[0])));
    }

    private List<String> getSentenceText(List<IToken> sentenceTokens) {
        ArrayList<String> result = new ArrayList<String>();
        for (IToken token : sentenceTokens) {
            result.add((String)token.getValue());
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.posModel.serialize((OutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.posModel = new POSModel((InputStream)in);
    }
}

