/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.featureextractors;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.IFeatureExtractorFactory;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.UnionFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.annotations.tokens.TokenSuffixFormFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.DocumentWithAnnotationFeatureExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public class SuffixFeatureExtractorFactory
implements IFeatureExtractorFactory<NLPDocumentWithAnnotation<IToken>> {
    private static final long serialVersionUID = -4370287434376000165L;
    private final int minimalLength;
    private final int maximalLength;

    public SuffixFeatureExtractorFactory() {
        this(1, 5);
    }

    public SuffixFeatureExtractorFactory(int minimalLength, int maximalLength) {
        Preconditions.checkArgument((minimalLength > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maximalLength >= minimalLength ? 1 : 0) != 0);
        this.minimalLength = minimalLength;
        this.maximalLength = maximalLength;
    }

    public IFeatureExtractor<NLPDocumentWithAnnotation<IToken>> create() {
        ArrayList<TokenSuffixFormFeatureExtractor> featureExtractors = new ArrayList<TokenSuffixFormFeatureExtractor>();
        for (int i = this.minimalLength; i <= this.maximalLength; ++i) {
            featureExtractors.add(new TokenSuffixFormFeatureExtractor(i));
        }
        return new DocumentWithAnnotationFeatureExtractor((IFeatureExtractor)new UnionFeatureExtractor(featureExtractors));
    }
}

