/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.classifiers.morph;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;
import ru.ispras.ml.classification.ConfidenceClassificationResult;
import ru.ispras.ml.classification.IConfidenceClassifier;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.classifiers.morph.IMorphClassifier;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;

public class MorphClassifier
implements IMorphClassifier,
Serializable {
    private static final long serialVersionUID = -8697023093461971452L;
    private final IPOSTag posTag;
    private final IConfidenceClassifier<IMorphProperties> morphClassifier;
    private final Set<IMorphProperties> posMorphTags;

    public MorphClassifier(IPOSTag posTag, IConfidenceClassifier<IMorphProperties> morphClassifier, Set<IMorphProperties> posMorphTags) {
        this.posTag = posTag;
        this.morphClassifier = morphClassifier;
        this.posMorphTags = ImmutableSet.copyOf(posMorphTags);
    }

    @Override
    public ConfidenceClassificationResult<IMorphProperties> predictMorphTag(IInstance featureInstance) {
        return this.morphClassifier.predict(featureInstance);
    }

    @Override
    public IPOSTag getPOSTag() {
        return this.posTag;
    }

    @Override
    public Set<IMorphProperties> getPOSMorphTags() {
        return this.posMorphTags;
    }
}

