/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos.hierarchical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.ispras.ml.classification.IConfidenceClassifier;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.InstanceFactory;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.classifiers.morph.IMorphClassifier;
import ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.dictionary.IPOSDictionary;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;

public class POSTagger
implements IAnnotator<POSToken>,
Serializable {
    private static final long serialVersionUID = 6561141200329846853L;
    private final InstanceFactory<NLPDocumentWithAnnotation<IToken>> instanceFactory;
    private final IConfidenceClassifier<IPOSTag> posTokenClassifier;
    private final Map<IPOSTag, IMorphClassifier> morphClassifiers;
    private final IPOSDictionary posDictionary;

    public POSTagger(IConfidenceClassifier<IPOSTag> posTokenClassifier, Map<IPOSTag, IMorphClassifier> morphClassifiers, InstanceFactory<NLPDocumentWithAnnotation<IToken>> instanceFactory, IPOSDictionary posDictionary) {
        this.posTokenClassifier = posTokenClassifier;
        this.morphClassifiers = morphClassifiers;
        this.instanceFactory = instanceFactory;
        this.posDictionary = posDictionary;
    }

    private Optional<IMorphProperties> detectPOSTagUsingDict(NLPDocumentWithAnnotation<IToken> nlpDocumentWithAnnotation) {
        return Optional.ofNullable(this.posDictionary.getPOSTag(((String)((IToken)nlpDocumentWithAnnotation.getAnnotation()).getValue()).toLowerCase()));
    }

    private IMorphProperties detectPOSTagUsingClassifiers(NLPDocumentWithAnnotation<IToken> nlpDocumentWithAnnotation) {
        IInstance featureInstance = this.instanceFactory.createInstance(nlpDocumentWithAnnotation);
        IPOSTag onlyPOSTag = (IPOSTag)this.posTokenClassifier.predict(featureInstance).getLabel();
        return (IMorphProperties)this.morphClassifiers.get(onlyPOSTag).predictMorphTag(featureInstance).getLabel();
    }

    public Collection<POSToken> annotate(INLPDocument doc) {
        List tokens = doc.getAnnotations(IToken.class);
        ArrayList<POSToken> posTokens = new ArrayList<POSToken>(tokens.size());
        for (IToken token : tokens) {
            NLPDocumentWithAnnotation docWithAnnotation = new NLPDocumentWithAnnotation(doc, (IAnnotation)token);
            Optional<IMorphProperties> posMorphTagOpt = this.detectPOSTagUsingDict((NLPDocumentWithAnnotation<IToken>)docWithAnnotation);
            IMorphProperties posMorphTag = posMorphTagOpt.orElseGet(() -> this.detectPOSTagUsingClassifiers((NLPDocumentWithAnnotation<IToken>)docWithAnnotation));
            POSToken posToken = new POSToken((IAnnotation)token, posMorphTag);
            posTokens.add(posToken);
            doc = doc.withAnnotations(Arrays.asList(posToken));
        }
        return posTokens;
    }
}

