/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.Collection;
import java.util.LinkedList;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.Span;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;

public final class OpenNLPSentenceDetector
implements IAnnotator<Sentence> {
    private final SentenceModel sentModel;

    public OpenNLPSentenceDetector(SentenceModel sentModel) {
        this.sentModel = sentModel;
    }

    public Collection<Sentence> annotate(INLPDocument doc) {
        LinkedList<Sentence> res = new LinkedList<Sentence>();
        SentenceDetectorME sd = new SentenceDetectorME(this.sentModel);
        for (Span s : sd.sentPosDetect(doc.getText())) {
            res.add(new Sentence(doc, s.getStart(), s.getEnd()));
        }
        return res;
    }
}

