/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import ru.ispras.modis.utils.xml.FilterIllegalCharactersXmlOutputFactory;
import ru.ispras.modis.utils.xml.JaxbChunkXmlElementUnparser;
import ru.ispras.modis.utils.xml.JaxbChunkXmlFactory;
import ru.ispras.modis.utils.xml.JaxbChunkXmlParser;

public abstract class JaxbChunkXmlProcessor<T> {
    private static final String ENCODING = "UTF-8";
    private final Class<T> elementClass;
    private final JAXBContext context;

    public JaxbChunkXmlProcessor(Class<T> clazz) throws JAXBException {
        this(clazz, JAXBContext.newInstance((Class[])new Class[]{clazz}));
    }

    public JaxbChunkXmlProcessor(Class<T> clazz, JAXBContext jAXBContext) {
        this.elementClass = clazz;
        this.context = jAXBContext;
    }

    public void processStreamsNoBuffering(InputStream inputStream, OutputStream outputStream) throws JAXBException, XMLStreamException {
        XMLStreamReader xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream, ENCODING);
        IndentingXMLStreamWriter indentingXMLStreamWriter = new IndentingXMLStreamWriter(FilterIllegalCharactersXmlOutputFactory.getXMLOutputFactory().createXMLStreamWriter(outputStream, ENCODING));
        this.processHeader(xMLStreamReader, (XMLStreamWriter)indentingXMLStreamWriter);
        JaxbChunkXmlFactory jaxbChunkXmlFactory = new JaxbChunkXmlFactory(this.context);
        JaxbChunkXmlParser<T> jaxbChunkXmlParser = jaxbChunkXmlFactory.createParser(this.elementClass);
        JaxbChunkXmlElementUnparser<T> jaxbChunkXmlElementUnparser = jaxbChunkXmlFactory.createRepetitivePartUnparser((XMLStreamWriter)indentingXMLStreamWriter, this.elementClass);
        for (T t : jaxbChunkXmlParser.parse(xMLStreamReader)) {
            this.process(t);
            jaxbChunkXmlElementUnparser.unparse(t);
        }
        indentingXMLStreamWriter.writeEndElement();
        indentingXMLStreamWriter.writeEndDocument();
        indentingXMLStreamWriter.close();
    }

    public void processStreams(InputStream inputStream, OutputStream outputStream) throws JAXBException, XMLStreamException, IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        this.processStreamsNoBuffering(new BufferedInputStream(inputStream), bufferedOutputStream);
        bufferedOutputStream.flush();
    }

    private void processHeader(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        while (xMLStreamReader.hasNext()) {
            if (xMLStreamReader.next() != 1) continue;
            this.cloneStartDocument(xMLStreamReader, xMLStreamWriter);
            this.cloneStartElement(xMLStreamReader, xMLStreamWriter);
            this.cloneAttributes(xMLStreamReader, xMLStreamWriter);
            break;
        }
    }

    private void cloneStartDocument(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamReader.getCharacterEncodingScheme();
        String string2 = xMLStreamReader.getVersion();
        if (string2 != null) {
            if (string != null) {
                xMLStreamWriter.writeStartDocument(string, string2);
            } else {
                xMLStreamWriter.writeStartDocument(string2);
            }
        } else {
            xMLStreamWriter.writeStartDocument();
        }
    }

    private void cloneStartElement(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamReader.getNamespaceURI();
        String string2 = xMLStreamReader.getLocalName();
        String string3 = xMLStreamReader.getPrefix();
        if (string != null) {
            if (string3 != null) {
                xMLStreamWriter.writeStartElement(string3, string2, string);
                xMLStreamWriter.writeNamespace(string3, string);
            } else {
                xMLStreamWriter.writeStartElement(string, string2);
                xMLStreamWriter.writeDefaultNamespace(string);
            }
        } else {
            xMLStreamWriter.writeStartElement(string2);
        }
    }

    private void cloneAttributes(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
            String string = xMLStreamReader.getAttributePrefix(i);
            String string2 = xMLStreamReader.getAttributeNamespace(i);
            String string3 = xMLStreamReader.getAttributeLocalName(i);
            String string4 = xMLStreamReader.getAttributeValue(i);
            if (string2 != null) {
                if (string != null) {
                    xMLStreamWriter.writeAttribute(string, string2, string3, string4);
                    continue;
                }
                xMLStreamWriter.writeAttribute(string2, string3, string4);
                continue;
            }
            xMLStreamWriter.writeAttribute(string3, string4);
        }
    }

    protected abstract void process(T var1);
}

