/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.xml;

import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class JaxbChunkXmlParser<T> {
    private static final String ENCODING = "UTF-8";
    private final Class<T> elementClass;
    private final QName elementQName;
    private final Unmarshaller unmarshaller;

    protected JaxbChunkXmlParser(Class<T> clazz, JAXBContext jAXBContext) throws JAXBException {
        this.unmarshaller = jAXBContext.createUnmarshaller();
        this.elementClass = clazz;
        this.elementQName = this.getElementQName(clazz, jAXBContext);
    }

    private QName getElementQName(Class<?> clazz, JAXBContext jAXBContext) {
        try {
            JAXBIntrospector jAXBIntrospector = jAXBContext.createJAXBIntrospector();
            Object obj = clazz.newInstance();
            return jAXBIntrospector.getElementName(obj);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Cannot determine xml element name for provided class.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Cannot determine xml element name for provided class.", illegalAccessException);
        }
    }

    public Iterable<T> parse(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(inputStream, ENCODING);
        return this.parse(xMLStreamReader);
    }

    public Iterable<T> parse(final XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new JaxbXmlIterator(xMLStreamReader);
            }
        };
    }

    private class JaxbXmlIterator
    implements Iterator<T> {
        private final XMLStreamReader reader;

        public JaxbXmlIterator(XMLStreamReader xMLStreamReader) {
            this.reader = xMLStreamReader;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.isSupportedElementHere(this.reader);
            }
            catch (XMLStreamException xMLStreamException) {
                return false;
            }
        }

        @Override
        public T next() {
            try {
                JAXBElement jAXBElement = JaxbChunkXmlParser.this.unmarshaller.unmarshal(this.reader, JaxbChunkXmlParser.this.elementClass);
                return jAXBElement.getValue();
            }
            catch (JAXBException jAXBException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean isSupportedElementHere(XMLStreamReader xMLStreamReader) throws XMLStreamException {
            while (xMLStreamReader.getEventType() != 1 || !xMLStreamReader.getName().equals(JaxbChunkXmlParser.this.elementQName)) {
                if (xMLStreamReader.hasNext()) {
                    xMLStreamReader.next();
                    continue;
                }
                return false;
            }
            return true;
        }
    }
}

