/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.xml;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChunkXmlMerger {
    private static final int BUFFER_SIZE = 1024;
    private static final Pattern containerTagPattern = Pattern.compile("(<.*>.*\\n?\\r?<(\\w*).*>\\n?)");
    private CharBuffer buffer = CharBuffer.allocate(1024);
    private int bufferUsedCapacity;
    private String header = null;
    private String containerTagName = null;
    private int bodyStart;
    private int bodyEnd;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 3) {
            ChunkXmlMerger.usage();
            return;
        }
        new ChunkXmlMerger().merge(Arrays.copyOfRange(stringArray, 0, stringArray.length - 1), stringArray[stringArray.length - 1]);
    }

    public void merge(String[] stringArray, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        this.processFirst(new FileReader(stringArray[0]), fileWriter);
        for (int i = 1; i < stringArray.length; ++i) {
            FileReader fileReader = new FileReader(stringArray[i]);
            this.processHeader(fileReader);
            this.processBody(fileReader, fileWriter);
        }
        this.finish(fileWriter);
    }

    private void finish(FileWriter fileWriter) throws IOException {
        fileWriter.write("</" + this.containerTagName + ">\n");
        fileWriter.close();
    }

    private void processFirst(InputStreamReader inputStreamReader, OutputStreamWriter outputStreamWriter) throws IOException {
        this.processHeader(inputStreamReader);
        outputStreamWriter.write(this.header);
        this.processBody(inputStreamReader, outputStreamWriter);
    }

    private void processHeader(InputStreamReader inputStreamReader) throws IOException {
        Matcher matcher;
        StringBuilder stringBuilder = new StringBuilder();
        this.bufferUsedCapacity = inputStreamReader.read(this.buffer);
        if (this.bufferUsedCapacity != -1) {
            stringBuilder.append(this.buffer.array());
            matcher = containerTagPattern.matcher(stringBuilder);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find container tag in the input.");
            }
        } else {
            throw new RuntimeException("Empty input. Please provide correct xml document.");
        }
        this.saveHeader(matcher.group(1));
        this.containerTagName = matcher.group(2);
        this.bodyStart = matcher.end();
    }

    private void saveHeader(String string) {
        if (this.header == null) {
            this.header = string;
        } else if (!this.header.equals(string)) {
            throw new RuntimeException("All processed documents should have the same header.");
        }
    }

    private void processBody(InputStreamReader inputStreamReader, OutputStreamWriter outputStreamWriter) throws IOException {
        Pattern pattern = Pattern.compile("</" + this.containerTagName + ">");
        String string = "";
        do {
            StringBuilder stringBuilder;
            Matcher matcher;
            if ((matcher = pattern.matcher(stringBuilder = new StringBuilder(string).append(this.buffer.array()))).find()) {
                this.bodyEnd = matcher.start() - string.length();
            } else {
                this.bodyEnd = this.bufferUsedCapacity;
                string = new String(this.buffer.array());
            }
            outputStreamWriter.write(this.buffer.array(), this.bodyStart, this.bodyEnd - this.bodyStart);
            this.bodyStart = 0;
            this.buffer.clear();
        } while ((this.bufferUsedCapacity = inputStreamReader.read(this.buffer)) != -1);
    }

    private static void usage() {
        System.out.println(String.format("%s <input file1> ... <input fileN> <output file>\n N >= 2", ChunkXmlMerger.class.getName()));
    }
}

