/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.lang.Validate;

public class CachingStreamSupplier<T>
implements Supplier<Stream<T>> {
    private static final int CHUNK_SIZE = 1024;
    private static final Path TEMP_PATH = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private final int numChunks;
    private final int chunkSize;
    private final int lastChunkSize;
    private final Path tempFilesPath;
    private final String tempFilesPrefix;

    public CachingStreamSupplier(Supplier<Stream<T>> supplier) {
        this(supplier, TEMP_PATH, CachingStreamSupplier.getDefaultFilesPrefix(), 1024);
    }

    public CachingStreamSupplier(Supplier<Stream<T>> supplier, int n) {
        this(supplier, TEMP_PATH, CachingStreamSupplier.getDefaultFilesPrefix(), n);
    }

    public CachingStreamSupplier(Supplier<Stream<T>> supplier, Path path, String string, int n) {
        Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"Chunk size should be positive");
        this.tempFilesPrefix = string;
        this.tempFilesPath = path;
        this.chunkSize = n;
        try (ToObjectStreamConsumer toObjectStreamConsumer = new ToObjectStreamConsumer(path, string, n);
             Stream stream = supplier.get();){
            stream.forEach(toObjectStreamConsumer);
            this.numChunks = toObjectStreamConsumer.getNumChunks();
            this.lastChunkSize = toObjectStreamConsumer.getCurrentChunkSize();
        }
    }

    @Override
    public Stream<T> get() {
        final ArrayList arrayList = new ArrayList();
        Spliterator spliterator = new Spliterator<T>(){
            private int currentChunkIndex = 0;
            private int currentChunkPointer = 0;
            private FileIterator<T> fileIterator = this.getFileIterator(this.currentChunkIndex, this.getChunkSize());

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.isCurrentChunkLast() && !this.fileIterator.hasNext()) {
                    return false;
                }
                if (!this.fileIterator.hasNext()) {
                    this.moveToNextFileIterator();
                }
                Object t = this.fileIterator.next();
                consumer.accept(t);
                ++this.currentChunkPointer;
                return true;
            }

            private void moveToNextFileIterator() {
                ++this.currentChunkIndex;
                this.fileIterator = this.getFileIterator(this.currentChunkIndex, this.getChunkSize());
                this.currentChunkPointer = 0;
            }

            private int getChunkSize() {
                return this.isCurrentChunkLast() ? CachingStreamSupplier.this.lastChunkSize : CachingStreamSupplier.this.chunkSize;
            }

            @Override
            public Spliterator<T> trySplit() {
                if (!this.isCurrentChunkLast()) {
                    Spliterator spliterator = Spliterators.spliterator(this.fileIterator, (long)(this.getChunkSize() - this.currentChunkPointer), 17472);
                    this.moveToNextFileIterator();
                    return spliterator;
                }
                return null;
            }

            private boolean isCurrentChunkLast() {
                return this.currentChunkIndex == CachingStreamSupplier.this.numChunks - 1;
            }

            @Override
            public long estimateSize() {
                return CachingStreamSupplier.this.chunkSize * (CachingStreamSupplier.this.numChunks - this.currentChunkIndex - 1) + CachingStreamSupplier.this.lastChunkSize - this.currentChunkPointer;
            }

            @Override
            public int characteristics() {
                return 17472;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private FileIterator<T> getFileIterator(int n, int n2) {
                ObjectInputStream objectInputStream = null;
                try {
                    objectInputStream = new ObjectInputStream(new InflaterInputStream(new FileInputStream(CachingStreamSupplier.getTempFile(CachingStreamSupplier.this.tempFilesPath, CachingStreamSupplier.this.tempFilesPrefix, n))));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                FileIterator fileIterator = new FileIterator(objectInputStream, n2);
                List list = arrayList;
                synchronized (list) {
                    arrayList.add(fileIterator);
                }
                return fileIterator;
            }
        };
        return (Stream)StreamSupport.stream(spliterator, true).onClose(() -> {
            List list2 = arrayList;
            synchronized (list2) {
                for (FileIterator fileIterator : arrayList) {
                    fileIterator.close();
                }
            }
        });
    }

    private static File getTempFile(Path path, String string, int n) {
        return new File(path.toFile(), string + "." + String.valueOf(n));
    }

    private static String getDefaultFilesPrefix() {
        return String.valueOf(System.nanoTime());
    }

    private static class FileIterator<T>
    implements Iterator<T>,
    AutoCloseable {
        private boolean closed = false;
        private final ObjectInputStream stream;
        private final int chunkSize;
        private int chunkPointer = 0;

        public FileIterator(ObjectInputStream objectInputStream, int n) {
            this.stream = objectInputStream;
            this.chunkSize = n;
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.stream.close();
                    this.closed = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.chunkPointer < this.chunkSize;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object object = this.stream.readObject();
                ++this.chunkPointer;
                if (!this.hasNext()) {
                    this.close();
                }
                return (T)object;
            }
            catch (IOException | ClassNotFoundException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static class ToObjectStreamConsumer<T>
    implements Consumer<T>,
    AutoCloseable {
        private final int chunkSize;
        private final Path tempFilesPath;
        private final String tempFilesPrefix;
        private int currentChunkIndex = 0;
        private int currentChunkSize = 0;
        private ObjectOutputStream ostream;

        public ToObjectStreamConsumer(Path path, String string, int n) {
            this.chunkSize = n;
            this.tempFilesPath = path;
            this.tempFilesPrefix = string;
            try {
                this.ostream = this.getObjectOutputStream(this.currentChunkIndex);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public int getNumChunks() {
            return this.currentChunkIndex + 1;
        }

        public int getCurrentChunkSize() {
            return this.currentChunkSize;
        }

        @Override
        public synchronized void accept(T t) {
            try {
                if (this.currentChunkSize >= this.chunkSize) {
                    this.ostream.close();
                    ++this.currentChunkIndex;
                    this.currentChunkSize = 0;
                    this.ostream = this.getObjectOutputStream(this.currentChunkIndex);
                }
                this.ostream.writeObject(t);
                ++this.currentChunkSize;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private ObjectOutputStream getObjectOutputStream(int n) throws FileNotFoundException, IOException {
            File file = CachingStreamSupplier.getTempFile(this.tempFilesPath, this.tempFilesPrefix, n);
            file.deleteOnExit();
            return new ObjectOutputStream(new DeflaterOutputStream(new FileOutputStream(file)));
        }

        @Override
        public void close() {
            try {
                this.ostream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

