/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.ispras.modis.utils.StreamUtils;

public class HttpMultipartData {
    private static final String CRLF = "\r\n";
    private static final String twoHyphens = "--";
    private static final String commonBoundary = "**MULTIPART*BOUNDARY**";
    private DataOutputStream stream;
    private String boundary = HttpMultipartData.generateBoundary();

    private void writeBoundary() throws IOException {
        this.stream.writeBytes(twoHyphens + this.boundary + CRLF);
    }

    protected void writeFinalBoundary() throws IOException {
        this.stream.writeBytes(twoHyphens + this.boundary + twoHyphens + CRLF);
    }

    public static String generateBoundary() {
        return commonBoundary;
    }

    public String getContentTypeString() {
        return "multipart/form-data;boundary=" + this.getBoundary();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void setStream(OutputStream outputStream) {
        this.stream = new DataOutputStream(outputStream);
    }

    public void addMultipartFile(String string, String string2, String string3, InputStream inputStream) throws IOException {
        this.writeBoundary();
        this.stream.writeBytes("Content-Disposition: form-data; name=\"" + string + "\";filename=\"" + string2 + "\"" + CRLF);
        this.stream.writeBytes("Content-Type: " + string3 + CRLF + CRLF);
        StreamUtils.copy(inputStream, this.stream);
        this.stream.writeBytes(CRLF);
    }

    public void close() throws IOException {
        this.writeFinalBoundary();
        this.stream.flush();
        this.stream.close();
    }
}

