/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.config.validation;

import com.impetus.annovention.ClasspathDiscoverer;
import com.impetus.annovention.listener.FieldAnnotationDiscoveryListener;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import ru.ispras.modis.utils.config.MultiSourceConfiguration;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.modis.utils.config.validation.ConfigurationValidator;
import ru.ispras.modis.utils.config.validation.JavaCodeUtils;

public class ConfigurationFilesValidator
extends ConfigurationValidator {
    private final String[] supportedAnnotations = new String[]{ConfigurationProperty.class.getName()};
    private final List<String> packagePrefixes;

    @Deprecated
    public ConfigurationFilesValidator(MultiSourceConfiguration multiSourceConfiguration) {
        this(multiSourceConfiguration, "");
    }

    public ConfigurationFilesValidator(MultiSourceConfiguration multiSourceConfiguration, String string) {
        this(multiSourceConfiguration, Arrays.asList(string));
    }

    public ConfigurationFilesValidator(MultiSourceConfiguration multiSourceConfiguration, List<String> list) {
        super(multiSourceConfiguration);
        this.packagePrefixes = list;
    }

    @Override
    public boolean validate() {
        ClasspathDiscoverer classpathDiscoverer = new ClasspathDiscoverer();
        PropertiesListener propertiesListener = new PropertiesListener();
        classpathDiscoverer.addAnnotationListener((FieldAnnotationDiscoveryListener)propertiesListener);
        classpathDiscoverer.discover();
        return !this.isFailed();
    }

    private class PropertiesListener
    implements FieldAnnotationDiscoveryListener {
        private PropertiesListener() {
        }

        public void discovered(String string, String string2, String string3) {
            if (!string3.equals(ConfigurationProperty.class.getName())) {
                Logger.getLogger(this.getClass()).warn((Object)("Unsupported annotation type: " + string3));
                return;
            }
            if (!this.classMustBeValidated(string)) {
                return;
            }
            String string4 = JavaCodeUtils.getConstantValue(string, string2);
            if (string4 == null) {
                ConfigurationFilesValidator.this.logError("Value is not found for field! \n\tClass: " + string + "\n\tField: " + string2 + "\n\tCheck, that class and field exist; field is declared as 'static final String'", null);
                return;
            }
            if (!ConfigurationFilesValidator.this.config.containsProperty(string, string4)) {
                ConfigurationFilesValidator.this.logError("Property not found in configuration! \n\tClass: " + string + "\n\tField: " + string2 + "\n\tProperty (field value): " + string4, null);
                return;
            }
        }

        public String[] supportedAnnotations() {
            return ConfigurationFilesValidator.this.supportedAnnotations;
        }

        private boolean classMustBeValidated(String string) {
            for (String string2 : ConfigurationFilesValidator.this.packagePrefixes) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
            return false;
        }
    }
}

