/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.config.generate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.commons.configuration.XMLConfiguration;
import ru.ispras.modis.utils.config.ConfigurationException;
import ru.ispras.modis.utils.config.selectors.ClasspathConfigFilesSelector;

public class Utils {
    private static final String YES = "y";
    private static final String NO = "n";
    public static final String ENCODING = "UTF-8";
    private static final BufferedReader reader;

    protected static String readFromConsole(String string) throws IOException {
        return Utils.readFromConsole(string, null, "");
    }

    protected static String readFromConsole(String string, String string2, String string3) throws IOException {
        System.out.println(string);
        if (string2 != null && !string2.isEmpty()) {
            System.out.println(string3 + string2);
        }
        System.out.print("> ");
        return reader.readLine();
    }

    public static String getAttribute(String string) {
        return "[@" + string + "]";
    }

    public static URL getFileURLFromClasspath(String string) {
        List<URI> list = new ClasspathConfigFilesSelector(string).getURIs();
        if (list.isEmpty()) {
            throw new ConfigurationException("No file found!");
        }
        try {
            URL uRL = list.get(0).toURL();
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException(malformedURLException);
        }
    }

    public static XMLConfiguration readXMLConfiguration(URL uRL) throws org.apache.commons.configuration.ConfigurationException {
        XMLConfiguration xMLConfiguration = new XMLConfiguration();
        xMLConfiguration.setDelimiterParsingDisabled(true);
        xMLConfiguration.load(uRL);
        return xMLConfiguration;
    }

    public static boolean askYesOrNo(String string) throws IOException {
        String string2;
        while (!(string2 = Utils.readFromConsole(string)).equalsIgnoreCase(YES)) {
            if (string2.equalsIgnoreCase(NO)) {
                return false;
            }
            System.out.println("Print 'y' or 'n'!");
            System.out.println();
        }
        return true;
    }

    static {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in, ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        }
        reader = bufferedReader;
    }
}

