/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.config;

public class Version
implements Comparable<Version> {
    private String version;
    private int[] numbers;

    public Version(String string) {
        this.version = string;
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1 && stringArray[0].isEmpty()) {
            this.numbers = new int[0];
            return;
        }
        this.numbers = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.numbers[i] = Integer.parseInt(stringArray[i]);
        }
    }

    public Version(int[] nArray) {
        this.numbers = nArray;
        this.version = this.makeString(nArray);
    }

    private String makeString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            stringBuilder.append(".");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Version version) {
        int n = Math.min(version.numbers.length, this.numbers.length);
        for (int i = 0; i < n; ++i) {
            if (this.numbers[i] == version.numbers[i]) continue;
            return this.numbers[i] - version.numbers[i];
        }
        return this.numbers.length - version.numbers.length;
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Version)) {
            return false;
        }
        return this.version.equals(((Version)object).version);
    }
}

