/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.config;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.log4j.Logger;
import ru.ispras.modis.utils.config.AttributesFilteringIterator;
import ru.ispras.modis.utils.config.ClassNodesCombiner;
import ru.ispras.modis.utils.config.ConfigurationException;
import ru.ispras.modis.utils.config.IXMLFileListener;

public class MultiSourceConfiguration {
    private static final String SCOPE = "scope";
    public static final String NO_SCOPE = null;
    private CombinedConfiguration classConfig;

    protected MultiSourceConfiguration(List<URI> list, IXMLFileListener iXMLFileListener) throws ConfigurationException {
        CombinedConfiguration combinedConfiguration = new CombinedConfiguration((NodeCombiner)new ClassNodesCombiner());
        for (URI uRI : list) {
            try {
                XMLConfiguration xMLConfiguration = new XMLConfiguration();
                xMLConfiguration.setDelimiterParsingDisabled(true);
                xMLConfiguration.load(uRI.toURL());
                iXMLFileListener.fileLoaded(uRI, xMLConfiguration);
                combinedConfiguration.addConfiguration((AbstractConfiguration)xMLConfiguration);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass()).warn((Object)("Error while loading configuration from:" + uRI + ". Skipping..."), (Throwable)exception);
            }
        }
        if (combinedConfiguration.getConfigurations().isEmpty()) {
            throw new ConfigurationException("No configuration files found!");
        }
        combinedConfiguration.setThrowExceptionOnMissing(true);
        this.classConfig = combinedConfiguration;
    }

    protected MultiSourceConfiguration(List<URI> list) {
        this(list, new IXMLFileListener(){

            @Override
            public void fileLoaded(URI uRI, XMLConfiguration xMLConfiguration) {
            }
        });
    }

    public String getStringProperty(Class<?> clazz, String string) throws ConversionException {
        return this.getStringProperty(clazz, string, NO_SCOPE);
    }

    public String getStringProperty(Class<?> clazz, String string, String string2) throws ConversionException {
        Map<String, List<String>> map = this.getPropertiesAt(clazz, string);
        if (map.containsKey(string2)) {
            return map.get(string2).get(0);
        }
        if (map.containsKey(NO_SCOPE)) {
            return map.get(NO_SCOPE).get(0);
        }
        throw new NoSuchElementException("Element not found: " + this.getKey(clazz, string));
    }

    public int getIntProperty(Class<?> clazz, String string) throws ConversionException {
        return this.getIntProperty(clazz, string, NO_SCOPE);
    }

    public int getIntProperty(Class<?> clazz, String string, String string2) throws ConversionException {
        try {
            return Integer.parseInt(this.getStringProperty(clazz, string, string2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConversionException((Throwable)numberFormatException);
        }
    }

    public long getLongProperty(Class<?> clazz, String string) throws ConversionException {
        return this.getLongProperty(clazz, string, NO_SCOPE);
    }

    public long getLongProperty(Class<?> clazz, String string, String string2) throws ConversionException {
        try {
            return Long.parseLong(this.getStringProperty(clazz, string, string2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConversionException((Throwable)numberFormatException);
        }
    }

    public boolean getBoolProperty(Class<?> clazz, String string) throws ConversionException {
        return this.getBoolProperty(clazz, string, NO_SCOPE);
    }

    public boolean getBoolProperty(Class<?> clazz, String string, String string2) throws ConversionException {
        String string3 = this.getStringProperty(clazz, string, string2);
        if ("true".equalsIgnoreCase(string3)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string3)) {
            return false;
        }
        throw new ConversionException("Cannot convert to boolean: " + string3);
    }

    public double getDoubleProperty(Class<?> clazz, String string) throws ConversionException {
        return this.getDoubleProperty(clazz, string, NO_SCOPE);
    }

    public double getDoubleProperty(Class<?> clazz, String string, String string2) throws ConversionException {
        try {
            return Double.parseDouble(this.getStringProperty(clazz, string, string2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConversionException((Throwable)numberFormatException);
        }
    }

    public List<String> getListProperty(Class<?> clazz, String string) throws ConversionException {
        return this.getListProperty(clazz, string, NO_SCOPE);
    }

    public List<String> getListProperty(Class<?> clazz, String string, String string2) throws ConversionException {
        return this.getListProperty(clazz, string, new String[]{string2});
    }

    public List<String> getListProperty(Class<?> clazz, String string, String[] stringArray) {
        return this.getListProperty(clazz, string, Arrays.asList(stringArray));
    }

    public List<String> getListProperty(Class<?> clazz, String string, Collection<String> collection) {
        Map<String, List<String>> map = this.getPropertiesAt(clazz, string);
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : collection) {
            String string3 = map.containsKey(string2) ? string2 : NO_SCOPE;
            if (hashSet.contains(string3)) continue;
            List<String> list = map.get(string3);
            if (list == null) {
                throw new NoSuchElementException();
            }
            arrayList.addAll(list);
            hashSet.add(string3);
        }
        return arrayList;
    }

    public Map<String, List<String>> getListPropertyAllScopes(Class<?> clazz, String string) {
        return this.getPropertiesAt(clazz, string);
    }

    public ClassProperties getClassProperties(Class<?> clazz) {
        return this.getPropertiesAt(clazz);
    }

    public ClassProperties getClassProperties(Class<?> clazz, String string) {
        return this.getClassProperties(clazz, new String[]{string});
    }

    public ClassProperties getClassProperties(Class<?> clazz, String[] stringArray) {
        return this.getClassProperties(clazz, Arrays.asList(stringArray));
    }

    public ClassProperties getClassProperties(Class<?> clazz, Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return new ClassProperties();
        }
        ClassProperties classProperties = this.getPropertiesAt(clazz);
        return classProperties.onlyTheseScopes(collection);
    }

    public List<ClassProperties> getClassPropertiesPerClassEntry(Class<?> clazz) {
        ArrayList<ClassProperties> arrayList = new ArrayList<ClassProperties>();
        ClassProperties classProperties = new ClassProperties();
        this.addSystemProperty(clazz, classProperties);
        if (!classProperties.isEmpty()) {
            arrayList.add(classProperties);
        }
        List list = this.classConfig.configurationsAt(this.getKey(clazz));
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            arrayList.add(this.fillClassProperties(new ClassProperties(), hierarchicalConfiguration));
        }
        return arrayList;
    }

    public boolean containsProperty(Class<?> clazz, String string) {
        return this.containsProperty(clazz, string, NO_SCOPE);
    }

    public boolean containsProperty(Class<?> clazz, String string, String string2) {
        return this.getPropertiesAt(clazz, string).containsKey(string2);
    }

    public boolean containsProperty(String string, String string2) {
        return this.classConfig.containsKey(this.getKey(string, string2));
    }

    private String getKey(Class<?> clazz, String string) {
        return this.getKey(this.getKey(clazz), string);
    }

    private String getKey(Class<?> clazz) {
        return clazz.getName();
    }

    private String getKey(String string, String string2) {
        String string3 = string + "." + string2;
        return string3;
    }

    private Map<String, List<String>> getPropertiesAt(Class<?> clazz, String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        this.addSystemProperty(clazz, string, hashMap);
        this.addNodeProperties(clazz, string, hashMap);
        return hashMap;
    }

    private void addNodeProperties(Class<?> clazz, String string, Map<String, List<String>> map) {
        List list = this.classConfig.configurationsAt(this.getKey(clazz, string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ConfigurationNode configurationNode = ((HierarchicalConfiguration)iterator.next()).getRootNode();
            String string2 = this.getScope(configurationNode);
            String string3 = this.getNodeValue(configurationNode);
            this.addProperty(map, string2, string3);
        }
    }

    private void addSystemProperty(Class<?> clazz, String string, Map<String, List<String>> map) {
        String string2 = System.getProperty(this.getKey(clazz, string));
        if (string2 != null) {
            this.addProperty(map, NO_SCOPE, string2);
        }
    }

    private void addProperty(Map<String, List<String>> map, String string, String string2) {
        List<String> list = map.get(string);
        if (list == null) {
            list = new ArrayList<String>(2);
            map.put(string, list);
        }
        list.add(string2);
    }

    private ClassProperties getPropertiesAt(Class<?> clazz) {
        ClassProperties classProperties = new ClassProperties();
        this.addSystemProperty(clazz, classProperties);
        this.addNodeProperties(clazz, classProperties);
        return classProperties;
    }

    private void addNodeProperties(Class<?> clazz, ClassProperties classProperties) {
        List list = this.classConfig.configurationsAt(this.getKey(clazz));
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            this.fillClassProperties(classProperties, hierarchicalConfiguration);
        }
    }

    private ClassProperties fillClassProperties(ClassProperties classProperties, HierarchicalConfiguration hierarchicalConfiguration) {
        for (ConfigurationNode configurationNode : hierarchicalConfiguration.getRootNode().getChildren()) {
            Map<String, List<String>> map = classProperties.propertyValues(configurationNode.getName());
            String string = this.getScope(configurationNode);
            String string2 = this.getNodeValue(configurationNode);
            this.addProperty(map, string, string2);
        }
        return classProperties;
    }

    private void addSystemProperty(Class<?> clazz, ClassProperties classProperties) {
        String string = this.getKey(clazz);
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string2;
            String string3 = entry.getKey().toString();
            if (!string3.startsWith(string) || (string2 = this.getPropertyName(string3, string)) == null) continue;
            this.addProperty(classProperties.propertyValues(string2), NO_SCOPE, entry.getValue().toString());
        }
    }

    private String getPropertyName(String string, String string2) {
        String[] stringArray = string.split(string2 + ".");
        if (stringArray.length > 1 && !stringArray[1].contains(".")) {
            return stringArray[1];
        }
        return null;
    }

    private String getScope(ConfigurationNode configurationNode) {
        List list = configurationNode.getAttributes(SCOPE);
        if (list.isEmpty()) {
            return NO_SCOPE;
        }
        return ((ConfigurationNode)list.get(0)).getValue().toString();
    }

    private String getNodeValue(ConfigurationNode configurationNode) {
        return configurationNode.getValue().toString();
    }

    public Iterator<String> getKeys() {
        return new AttributesFilteringIterator(this.classConfig.getKeys());
    }

    public static OSType getOSType() {
        Logger.getLogger(Configuration.class).trace((Object)"Looking for OS type");
        String string = System.getProperty("os.name");
        OSType oSType = string.indexOf("Windows") != -1 ? OSType.DOS : OSType.UNIX;
        Logger.getLogger(Configuration.class).trace((Object)("Looks like we are on " + (Object)((Object)oSType)));
        return oSType;
    }

    public static String getHostname() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public static enum OSType {
        UNIX,
        DOS;

    }

    public static class ClassProperties {
        private final Map<String, Map<String, List<String>>> propertiesStorage = new HashMap<String, Map<String, List<String>>>();

        public Map<String, List<String>> getPropertyValues(String string) {
            Map<String, List<String>> map = this.propertiesStorage.get(string);
            return map != null ? Collections.unmodifiableMap(map) : null;
        }

        public Collection<String> getPropertyNames() {
            return Collections.unmodifiableSet(this.propertiesStorage.keySet());
        }

        public boolean isEmpty() {
            return this.propertiesStorage.isEmpty();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ClassProperties) {
                return ((ClassProperties)object).propertiesStorage.equals(this.propertiesStorage);
            }
            return false;
        }

        public int hashCode() {
            return this.propertiesStorage.hashCode();
        }

        Map<String, List<String>> propertyValues(String string) {
            if (this.propertiesStorage.containsKey(string)) {
                return this.propertiesStorage.get(string);
            }
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            this.propertiesStorage.put(string, hashMap);
            return hashMap;
        }

        ClassProperties onlyTheseScopes(Collection<String> collection) {
            Iterator<Map<String, List<String>>> iterator = this.propertiesStorage.values().iterator();
            while (iterator.hasNext()) {
                Map<String, List<String>> map = iterator.next();
                map.keySet().retainAll(collection);
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return this;
        }
    }
}

