/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import ru.ispras.modis.utils.concurrent.ExecutorServiceHelper;

public class StreamProcessor {
    private final ExecutorService executorService;
    private final boolean shouldShutdown;

    public StreamProcessor() {
        this.executorService = ExecutorServiceHelper.forAvailableProcessors();
        this.shouldShutdown = true;
    }

    public StreamProcessor(ExecutorService executorService) {
        this.executorService = executorService;
        this.shouldShutdown = false;
    }

    public <I, O> Iterable<O> transform(final Iterable<I> iterable, final IElementTransformer<I, O> iElementTransformer) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new TransformingIterator(iterable.iterator(), iElementTransformer);
            }
        };
    }

    public <I> void process(Iterable<I> iterable, IElementProcessor<I> iElementProcessor) {
        ProcessorTransformerAdapter<I> processorTransformerAdapter = new ProcessorTransformerAdapter<I>(iElementProcessor);
        for (Object o : this.transform(iterable, processorTransformerAdapter)) {
        }
    }

    static /* synthetic */ ExecutorService access$300(StreamProcessor streamProcessor) {
        return streamProcessor.executorService;
    }

    static /* synthetic */ boolean access$700(StreamProcessor streamProcessor) {
        return streamProcessor.shouldShutdown;
    }

    private static class ProcessorTransformerAdapter<I>
    implements IElementTransformer<I, I> {
        private final IElementProcessor<I> processor;

        public ProcessorTransformerAdapter(IElementProcessor<I> iElementProcessor) {
            this.processor = iElementProcessor;
        }

        @Override
        public I transformElement(I i) {
            this.processor.processElement(i);
            return i;
        }
    }

    private class TransformingIterator<I, O>
    implements Iterator<O> {
        private static final int BUFFER_SIZE = 1024;
        private final Iterator<I> input;
        private final ArrayBlockingQueue<Future<O>> buffer;
        private final ExecutorService processingManager;
        private final IElementTransformer<I, O> transformer;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition notFull = this.lock.newCondition();
        private final Condition notEmpty = this.lock.newCondition();

        public TransformingIterator(Iterator<I> iterator, IElementTransformer<I, O> iElementTransformer) {
            this.input = iterator;
            this.buffer = new ArrayBlockingQueue(1024);
            this.transformer = iElementTransformer;
            this.processingManager = Executors.newSingleThreadExecutor();
            this.processingManager.execute(new ProcessingManagementTask());
            this.processingManager.shutdown();
        }

        @Override
        public boolean hasNext() {
            this.lock.lock();
            try {
                boolean bl = this.internalHasNext();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean internalHasNext() {
            return !this.buffer.isEmpty() || this.input.hasNext();
        }

        @Override
        public O next() {
            Future<O> future;
            this.lock.lock();
            try {
                if (!this.internalHasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    while (this.buffer.isEmpty()) {
                        this.notEmpty.await();
                    }
                    future = this.buffer.take();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                this.notFull.signal();
            }
            finally {
                this.lock.unlock();
            }
            try {
                O o = future.get();
                return o;
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ ReentrantLock access$000(TransformingIterator transformingIterator) {
            return transformingIterator.lock;
        }

        static /* synthetic */ Iterator access$100(TransformingIterator transformingIterator) {
            return transformingIterator.input;
        }

        static /* synthetic */ IElementTransformer access$200(TransformingIterator transformingIterator) {
            return transformingIterator.transformer;
        }

        static /* synthetic */ ArrayBlockingQueue access$400(TransformingIterator transformingIterator) {
            return transformingIterator.buffer;
        }

        static /* synthetic */ Condition access$500(TransformingIterator transformingIterator) {
            return transformingIterator.notFull;
        }

        static /* synthetic */ Condition access$600(TransformingIterator transformingIterator) {
            return transformingIterator.notEmpty;
        }

        private class ProcessingManagementTask
        implements Runnable {
            private ProcessingManagementTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block13: {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        TransformingIterator.access$000(TransformingIterator.this).lock();
                        try {
                            if (TransformingIterator.access$100(TransformingIterator.this).hasNext()) {
                                var1_1 = TransformingIterator.access$100(TransformingIterator.this).next();
                                var2_3 = StreamProcessor.access$300(StreamProcessor.this).submit(new TransformationTask<E, O>(var1_1, TransformingIterator.access$200(TransformingIterator.this)));
                                while (TransformingIterator.access$400(TransformingIterator.this).remainingCapacity() == 0) {
                                    TransformingIterator.access$500(TransformingIterator.this).await();
                                }
                                TransformingIterator.access$400(TransformingIterator.this).put(var2_3);
                                TransformingIterator.access$600(TransformingIterator.this).signal();
                            }
                            break block13;
                        }
                        catch (InterruptedException var1_2) {
                            throw new RuntimeException(var1_2);
                        }
                        finally {
                            TransformingIterator.access$000(TransformingIterator.this).unlock();
                            continue;
                        }
                        break;
                    }
                    ** GOTO lbl-1000
                    finally {
                        if (StreamProcessor.access$700(StreamProcessor.this)) {
                            StreamProcessor.access$300(StreamProcessor.this).shutdown();
                        }
                    }
                }
            }
        }
    }

    private static class TransformationTask<I, O>
    implements Callable<O> {
        private final I input;
        private final IElementTransformer<I, O> transformer;

        public TransformationTask(I i, IElementTransformer<I, O> iElementTransformer) {
            this.input = i;
            this.transformer = iElementTransformer;
        }

        @Override
        public O call() throws Exception {
            return this.transformer.transformElement(this.input);
        }
    }

    public static interface IElementTransformer<I, O> {
        public O transformElement(I var1);
    }

    public static interface IElementProcessor<I> {
        public void processElement(I var1);
    }
}

