/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import ru.ispras.modis.utils.concurrent.CantGetTaskResultException;

public class FutureUtils {
    public static <R> R getResult(Future<R> future) throws CantGetTaskResultException {
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            throw new CantGetTaskResultException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new CantGetTaskResultException(executionException);
        }
    }

    public static <R> List<R> getResults(List<Future<R>> list) throws CantGetTaskResultException {
        ArrayList<R> arrayList = new ArrayList<R>(list.size());
        for (Future<R> future : list) {
            arrayList.add(FutureUtils.getResult(future));
        }
        return arrayList;
    }
}

