/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class LimitedWeightList<KEY> {
    private List<WeightedKey> weightedKeys = new ArrayList<WeightedKey>();
    private long freeWeight;
    private final long maxWeight;

    public LimitedWeightList(long l) {
        this.freeWeight = l;
        this.maxWeight = l;
    }

    public boolean freeSpaceToFit(long l, Map<KEY, ?> map) {
        long l2;
        long l3;
        if (this.maxWeight < l) {
            return false;
        }
        int n = this.weightedKeys.size() - 1;
        for (l2 = this.freeWeight; n >= 0 && l2 < l; l2 += l3, --n) {
            l3 = this.weightedKeys.get(n).getWeight();
            if (l3 < l) continue;
            return false;
        }
        if (l2 < l) {
            return false;
        }
        for (int i = this.weightedKeys.size() - 1; i > n; --i) {
            WeightedKey weightedKey = this.weightedKeys.remove(i);
            this.freeWeight += weightedKey.getWeight();
            map.remove(weightedKey.getKey());
        }
        return true;
    }

    public void add(KEY KEY, long l) {
        WeightedKey weightedKey = new WeightedKey(KEY, l);
        int n = Collections.binarySearch(this.weightedKeys, weightedKey);
        if (n < 0) {
            n = -n - 1;
        } else if (weightedKey.equals(this.weightedKeys.get(n))) {
            return;
        }
        this.weightedKeys.add(n, weightedKey);
        this.freeWeight -= l;
    }

    class WeightedKey
    implements Comparable<WeightedKey> {
        private KEY key;
        private long weight;

        public WeightedKey(KEY KEY, long l) {
            this.key = KEY;
            this.weight = l;
        }

        public long getWeight() {
            return this.weight;
        }

        public KEY getKey() {
            return this.key;
        }

        public boolean equals(Object object) {
            if (object instanceof WeightedKey) {
                WeightedKey weightedKey = (WeightedKey)object;
                return weightedKey.getWeight() == this.getWeight() && this.getKey().equals(weightedKey.getKey());
            }
            return false;
        }

        @Override
        public int compareTo(WeightedKey weightedKey) {
            return this.weight < weightedKey.weight ? 1 : (this.weight == weightedKey.weight ? 0 : -1);
        }
    }
}

