/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections.cache;

import java.util.concurrent.ConcurrentHashMap;
import ru.ispras.modis.utils.collections.cache.IAcceptor;
import ru.ispras.modis.utils.collections.cache.ICache;
import ru.ispras.modis.utils.collections.cache.IEntryWeightComputer;
import ru.ispras.modis.utils.collections.cache.LimitedWeightList;

public class LimitedWeightCache<KEY, VAL>
implements ICache<KEY, VAL> {
    private IAcceptor<KEY> acceptor;
    private IEntryWeightComputer<VAL> weightComputer;
    private ConcurrentHashMap<KEY, VAL> cacheMap;
    private LimitedWeightList<KEY> weightedKeys;

    public LimitedWeightCache(IAcceptor<KEY> iAcceptor, IEntryWeightComputer<VAL> iEntryWeightComputer, long l) {
        this.acceptor = iAcceptor;
        this.weightComputer = iEntryWeightComputer;
        this.cacheMap = new ConcurrentHashMap();
        this.weightedKeys = new LimitedWeightList(l);
    }

    @Override
    public void put(KEY KEY, VAL VAL) {
        if (this.acceptor.accept(KEY)) {
            this.tryToPut(KEY, VAL);
        }
    }

    private synchronized void tryToPut(KEY KEY, VAL VAL) {
        if (this.cacheMap.containsKey(KEY)) {
            return;
        }
        long l = this.weightComputer.computeEntryWeight(VAL);
        if (!this.weightedKeys.freeSpaceToFit(l, this.cacheMap)) {
            return;
        }
        this.weightedKeys.add(KEY, l);
        this.cacheMap.put(KEY, VAL);
    }

    @Override
    public VAL get(KEY KEY) {
        if (!this.acceptor.accept(KEY)) {
            return null;
        }
        return this.cacheMap.get(KEY);
    }
}

