/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import gnu.trove.procedure.TObjectDoubleProcedure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.MultiMap;
import org.apache.commons.collections15.multimap.MultiHashMap;
import org.apache.commons.lang.StringUtils;

public class SnakeKeyDoubleHashMap<KH, KT>
implements Serializable {
    private static final long serialVersionUID = -6105185861822506426L;
    private HashMap<KH, TObjectDoubleHashMap<KT>> storage = new HashMap();

    public boolean containsKey(KH KH, KT KT) {
        return this.containsKey(KH) && this.storage.get(KH).containsKey(KT);
    }

    public boolean containsKey(KH KH) {
        return this.storage.containsKey(KH);
    }

    public double get(KH KH, KT KT) {
        if (this.containsKey(KH, KT)) {
            return this.storage.get(KH).get(KT);
        }
        return 0.0;
    }

    public double get(KeyPair<KH, KT> keyPair) {
        return this.get(((KeyPair)keyPair).head, ((KeyPair)keyPair).tail);
    }

    public double put(KH KH, KT KT, double d) {
        if (this.storage.containsKey(KH)) {
            return this.storage.get(KH).put(KT, d);
        }
        TObjectDoubleHashMap tObjectDoubleHashMap = new TObjectDoubleHashMap();
        tObjectDoubleHashMap.put(KT, d);
        this.storage.put(KH, tObjectDoubleHashMap);
        return 0.0;
    }

    public TObjectDoubleHashMap<KT> getTails(KH KH) {
        return this.storage.get(KH);
    }

    public KT getMostValuableTail(KH KH) {
        TObjectDoubleHashMap<KT> tObjectDoubleHashMap = this.storage.get(KH);
        double d = Double.MIN_VALUE;
        KT KT = null;
        for (Object e : tObjectDoubleHashMap.keySet()) {
            double d2 = tObjectDoubleHashMap.get(e);
            if (KT != null && !(d < d2)) continue;
            KT = (KT)e;
            d = d2;
        }
        return KT;
    }

    public Map<KH, KT> getMostValuableMap() {
        HashMap<KH, KT> hashMap = new HashMap<KH, KT>();
        for (KH KH : this.storage.keySet()) {
            hashMap.put(KH, this.getMostValuableTail(KH));
        }
        return hashMap;
    }

    public MultiMap<KH, KT> getMostValuableMultiMap() {
        MultiHashMap multiHashMap = new MultiHashMap();
        for (KH KH : this.storage.keySet()) {
            multiHashMap.putAll(KH, this.getMostValuableTails(KH));
        }
        return multiHashMap;
    }

    public Collection<? extends KT> getMostValuableTails(KH KH) {
        TObjectDoubleHashMap<KT> tObjectDoubleHashMap = this.storage.get(KH);
        double d = Double.MIN_VALUE;
        LinkedList linkedList = null;
        for (Object e : tObjectDoubleHashMap.keySet()) {
            double d2 = tObjectDoubleHashMap.get(e);
            if (this.isNewMaxFound(d, linkedList, d2)) {
                linkedList = new LinkedList();
                linkedList.add(e);
                d = d2;
                continue;
            }
            if (d != d2) continue;
            linkedList.add(e);
        }
        return linkedList;
    }

    private boolean isNewMaxFound(double d, Collection<KT> collection, double d2) {
        return collection == null || d < d2;
    }

    public Collection<KH> getHeads() {
        return this.storage.keySet();
    }

    public Set<KeyPair<KH, KT>> getKeyPairSet() {
        HashSet<KeyPair<KH, KT>> hashSet = new HashSet<KeyPair<KH, KT>>();
        for (KH KH : this.storage.keySet()) {
            Set set = this.storage.get(KH).keySet();
            for (Object e : set) {
                hashSet.add(new KeyPair(KH, e));
            }
        }
        return hashSet;
    }

    public void remove(KH KH) {
        this.storage.remove(KH);
    }

    public String toString() {
        final ArrayList arrayList = new ArrayList();
        for (Map.Entry<KH, TObjectDoubleHashMap<KT>> entry : this.storage.entrySet()) {
            final KH KH = entry.getKey();
            entry.getValue().forEachEntry(new TObjectDoubleProcedure<KT>(){

                public boolean execute(KT KT, double d) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(KH).append("=").append(KT).append("=").append(d);
                    arrayList.add(stringBuilder.toString());
                    return true;
                }
            });
        }
        StringBuilder stringBuilder = new StringBuilder("{").append(StringUtils.join(arrayList, (String)", "));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static class KeyPair<KPH, KPT> {
        private KPH head;
        private KPT tail;

        private KeyPair(KPH KPH, KPT KPT) {
            this.head = KPH;
            this.tail = KPT;
        }

        public KPH getHead() {
            return this.head;
        }

        public KPT getTail() {
            return this.tail;
        }
    }
}

